/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.orca.stage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.kayenta.canary.CanaryScope;
import com.netflix.kayenta.canary.CanaryScopePair;
import com.netflix.kayenta.standalonecanaryanalysis.CanaryAnalysisConfig;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionRequest;
import com.netflix.kayenta.standalonecanaryanalysis.orca.RunCanaryContext;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageGraphBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.TaskNode;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.pipeline.WaitStage;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetupAndExecuteCanariesStage
implements StageDefinitionBuilder {
    public static final String STAGE_TYPE = "setupAndExecuteCanariesStage";
    public static final String STAGE_DESCRIPTION = "Sets up and executes the wait, run and monitor canary task chain.";
    private static final Instant ZERO_AS_INSTANT = Instant.ofEpochMilli(Duration.ZERO.toMillis());
    private final Clock clock;
    private final ObjectMapper kayentaObjectMapper;

    @Autowired
    public SetupAndExecuteCanariesStage(Clock clock, ObjectMapper kayentaObjectMapper) {
        this.clock = clock;
        this.kayentaObjectMapper = kayentaObjectMapper;
    }

    public void taskGraph(@Nonnull StageExecution stage, @Nonnull TaskNode.Builder builder) {
    }

    public void beforeStages(@Nonnull StageExecution parent, @Nonnull StageGraphBuilder graph) {
        CanaryAnalysisConfig canaryAnalysisConfig = (CanaryAnalysisConfig)this.kayentaObjectMapper.convertValue(parent.getContext().get("canaryAnalysisExecutionRequest"), CanaryAnalysisConfig.class);
        CanaryAnalysisExecutionRequest canaryAnalysisExecutionRequest = canaryAnalysisConfig.getExecutionRequest();
        if (canaryAnalysisExecutionRequest.getScopes().isEmpty()) {
            throw new IllegalArgumentException("Canary StageExecution configuration must contain at least one scope.");
        }
        Instant start = Optional.ofNullable(canaryAnalysisExecutionRequest.getStartTime()).orElse(Instant.now(this.clock));
        Instant endTime = canaryAnalysisExecutionRequest.getEndTime();
        Duration lifetime = this.calculateLifetime(start, endTime, canaryAnalysisExecutionRequest);
        Duration analysisInterval = this.calculateAnalysisInterval(canaryAnalysisExecutionRequest, lifetime);
        if (canaryAnalysisExecutionRequest.getBeginCanaryAnalysisAfterAsInstant().isAfter(ZERO_AS_INSTANT)) {
            graph.append(stage -> {
                stage.setType(WaitStage.STAGE_TYPE);
                stage.setName("Warmup Wait");
                stage.getContext().put("waitTime", canaryAnalysisExecutionRequest.getBeginCanaryAnalysisAfterAsDuration().getSeconds());
            });
        }
        int numberOfJudgements = Math.toIntExact(lifetime.toMinutes() / analysisInterval.toMinutes());
        for (int i = 1; i < numberOfJudgements + 1; ++i) {
            int index = i;
            if (endTime == null) {
                graph.append(stage -> {
                    stage.setType(WaitStage.STAGE_TYPE);
                    stage.setName("Interval Wait #" + index);
                    stage.getContext().put("waitTime", analysisInterval.getSeconds());
                });
            }
            RunCanaryContext runCanaryContext = RunCanaryContext.builder().application(canaryAnalysisConfig.getApplication()).user(canaryAnalysisConfig.getUser()).parentPipelineExecutionId(canaryAnalysisConfig.getParentPipelineExecutionId()).canaryConfigId(canaryAnalysisConfig.getCanaryConfigId()).metricsAccountName(canaryAnalysisConfig.getMetricsAccountName()).storageAccountName(canaryAnalysisConfig.getStorageAccountName()).canaryConfig(canaryAnalysisConfig.getCanaryConfig()).scopes(this.buildRequestScopes(canaryAnalysisExecutionRequest, i, analysisInterval)).scoreThresholds(canaryAnalysisExecutionRequest.getThresholds()).siteLocal(canaryAnalysisExecutionRequest.getSiteLocal()).build();
            graph.append(stage -> {
                stage.setType("runCanary");
                stage.setName("Run Canary #" + index);
                stage.getContext().putAll((Map)this.kayentaObjectMapper.convertValue((Object)runCanaryContext, (TypeReference)new TypeReference<HashMap<String, Object>>(){}));
            });
        }
    }

    protected Duration calculateLifetime(Instant start, Instant endTime, CanaryAnalysisExecutionRequest canaryAnalysisExecutionRequest) {
        Duration lifetime;
        if (endTime != null) {
            lifetime = Duration.ofMinutes(start.until(endTime, ChronoUnit.MINUTES));
        } else if (canaryAnalysisExecutionRequest.getLifetimeDuration() != null) {
            lifetime = canaryAnalysisExecutionRequest.getLifetimeDuration();
        } else {
            throw new IllegalArgumentException("Canary StageExecution configuration must include either `endTime` or `lifetimeDuration`.");
        }
        return lifetime;
    }

    protected Duration calculateAnalysisInterval(CanaryAnalysisExecutionRequest canaryAnalysisExecutionRequest, Duration lifetime) {
        Duration analysisInterval = canaryAnalysisExecutionRequest.getAnalysisIntervalMins() != null ? Duration.ofMinutes(canaryAnalysisExecutionRequest.getAnalysisIntervalMins()) : lifetime;
        if (analysisInterval == Duration.ZERO || Instant.ofEpochMilli(analysisInterval.toMillis()).isAfter(Instant.ofEpochMilli(lifetime.toMillis()))) {
            analysisInterval = lifetime;
        }
        return analysisInterval;
    }

    protected Map<String, CanaryScopePair> buildRequestScopes(CanaryAnalysisExecutionRequest config, long interval, Duration intervalDuration) {
        HashMap<String, CanaryScopePair> scopes = new HashMap<String, CanaryScopePair>();
        config.getScopes().forEach(scope -> {
            ScopeTimeConfig scopeTimeConfig = this.calculateStartAndEndForJudgement(config, interval, intervalDuration);
            CanaryScope controlScope = new CanaryScope(scope.getControlScope(), scope.getControlLocation(), scopeTimeConfig.start.minus(Duration.ofMinutes(scope.getControlOffsetInMinutes())), scopeTimeConfig.end.minus(Duration.ofMinutes(scope.getControlOffsetInMinutes())), Long.valueOf(config.getStep().getSeconds()), scope.getExtendedScopeParams());
            CanaryScope experimentScope = new CanaryScope(scope.getExperimentScope(), scope.getExperimentLocation(), scopeTimeConfig.start, scopeTimeConfig.end, Long.valueOf(config.getStep().getSeconds()), scope.getExtendedScopeParams());
            CanaryScopePair canaryScopePair = CanaryScopePair.builder().controlScope(controlScope).experimentScope(experimentScope).build();
            scopes.put(scope.getScopeName(), canaryScopePair);
        });
        return scopes;
    }

    protected ScopeTimeConfig calculateStartAndEndForJudgement(CanaryAnalysisExecutionRequest config, long judgementNumber, Duration judgementDuration) {
        Instant startTime;
        Duration warmupDuration = config.getBeginCanaryAnalysisAfterAsDuration();
        Duration offset = judgementDuration.multipliedBy(judgementNumber);
        ScopeTimeConfig scopeTimeConfig = new ScopeTimeConfig();
        scopeTimeConfig.start = startTime = Optional.ofNullable(config.getStartTime()).orElse(Instant.now(this.clock));
        scopeTimeConfig.end = startTime.plus(offset);
        if (config.getEndTime() == null) {
            scopeTimeConfig.start = scopeTimeConfig.start.plus(warmupDuration);
            scopeTimeConfig.end = scopeTimeConfig.end.plus(warmupDuration);
        }
        if (config.getLookBackAsInstant().isAfter(ZERO_AS_INSTANT)) {
            scopeTimeConfig.start = scopeTimeConfig.end.minus(config.getLookBackAsDuration());
        }
        return scopeTimeConfig;
    }

    public void onFailureStages(@Nonnull StageExecution parent, @Nonnull StageGraphBuilder graph) {
        this.addAlwaysRunResultStage(parent, graph);
    }

    public void afterStages(@Nonnull StageExecution parent, @Nonnull StageGraphBuilder graph) {
        this.addAlwaysRunResultStage(parent, graph);
    }

    private void addAlwaysRunResultStage(@Nonnull StageExecution parent, @Nonnull StageGraphBuilder graph) {
        graph.append(stage -> {
            stage.setType("generateCanaryAnalysisResultStage");
            stage.setName("Aggregates and evaluates the canary executions and generates the final results.");
            stage.setContext(parent.getContext());
        });
    }

    @Nonnull
    public String getType() {
        return STAGE_TYPE;
    }

    class ScopeTimeConfig {
        private Instant start;
        private Instant end;

        public Instant getStart() {
            return this.start;
        }

        public Instant getEnd() {
            return this.end;
        }

        public ScopeTimeConfig setStart(Instant start) {
            this.start = start;
            return this;
        }

        public ScopeTimeConfig setEnd(Instant end) {
            this.end = end;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScopeTimeConfig)) {
                return false;
            }
            ScopeTimeConfig other = (ScopeTimeConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Instant this$start = this.getStart();
            Instant other$start = other.getStart();
            if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
                return false;
            }
            Instant this$end = this.getEnd();
            Instant other$end = other.getEnd();
            return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScopeTimeConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Instant $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
            Instant $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
            return result;
        }

        public String toString() {
            return "SetupAndExecuteCanariesStage.ScopeTimeConfig(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
        }
    }
}

