/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.event;

import com.netflix.kayenta.events.AbstractExecutionCompleteEventProcessor;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionStatusResponse;
import com.netflix.kayenta.standalonecanaryanalysis.event.StandaloneCanaryAnalysisExecutionCompletedEvent;
import com.netflix.kayenta.standalonecanaryanalysis.service.CanaryAnalysisService;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class StandaloneCanaryAnalysisExecutionCompletedProducer
extends AbstractExecutionCompleteEventProcessor {
    private final CanaryAnalysisService canaryAnalysisService;

    public StandaloneCanaryAnalysisExecutionCompletedProducer(ApplicationEventPublisher applicationEventPublisher, ExecutionRepository executionRepository, CanaryAnalysisService canaryAnalysisService) {
        super(applicationEventPublisher, executionRepository);
        this.canaryAnalysisService = canaryAnalysisService;
    }

    public boolean shouldProcessExecution(PipelineExecution execution) {
        return "Standalone Canary Analysis Pipeline".equals(execution.getName());
    }

    public void processCompletedPipelineExecution(PipelineExecution execution) {
        CanaryAnalysisExecutionStatusResponse canaryAnalysisExecution = this.canaryAnalysisService.getCanaryAnalysisExecution(execution.getId(), null);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new StandaloneCanaryAnalysisExecutionCompletedEvent((Object)this, canaryAnalysisExecution));
    }
}

