/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.controller;

import com.netflix.kayenta.canary.CanaryConfig;
import com.netflix.kayenta.canary.providers.metrics.QueryConfigUtils;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import com.netflix.kayenta.standalonecanaryanalysis.CanaryAnalysisConfig;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisAdhocExecutionRequest;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionRequest;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionResponse;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionStatusResponse;
import com.netflix.kayenta.standalonecanaryanalysis.service.CanaryAnalysisService;
import com.netflix.kayenta.storage.ObjectType;
import com.netflix.kayenta.storage.StorageService;
import com.netflix.kayenta.storage.StorageServiceRepository;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="Standalone Canary Analysis Controller - endpoints for performing multiple canary judgements over a period of time, past or present")
@RequestMapping(value={"/standalone_canary_analysis"})
public class StandaloneCanaryAnalysisController {
    private static final Logger log = LoggerFactory.getLogger(StandaloneCanaryAnalysisController.class);
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final CanaryAnalysisService canaryAnalysisService;
    private final StorageServiceRepository storageServiceRepository;
    private final String AD_HOC = "ad-hoc";

    @Autowired
    public StandaloneCanaryAnalysisController(AccountCredentialsRepository accountCredentialsRepository, CanaryAnalysisService canaryAnalysisService, StorageServiceRepository storageServiceRepository) {
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.canaryAnalysisService = canaryAnalysisService;
        this.storageServiceRepository = storageServiceRepository;
    }

    @ApiOperation(value="Initiate a canary analysis execution with multiple canary judgements using a stored canary config")
    @RequestMapping(value={"/{canaryConfigId:.+}"}, consumes={"application/json"}, method={RequestMethod.POST})
    public CanaryAnalysisExecutionResponse initiateCanaryAnalysis(@ApiParam(value="The initiating user", defaultValue="anonymous", example="justin.field@example.com") @RequestParam(required=false) String user, @ApiParam(value="The application under test", example="examplecanarymicroservice") @RequestParam(required=false) String application, @ApiParam(value="The parent pipeline execution id, if this is being executed as a StageExecution in another pipeline", example="01CYZCD53RBX2KR2Q9GY0218UI") @RequestParam(required=false) String parentPipelineExecutionId, @ApiParam(value="The account that has the metrics for the application under test", example="some-metrics-account") @RequestParam(required=false) String metricsAccountName, @ApiParam(value="The account that has the supplied canary config id", example="some-config-account") @RequestParam(required=false) String configurationAccountName, @ApiParam(value="The account that will be used to store results", example="some-storage-account") @RequestParam(required=false) String storageAccountName, @ApiParam(required=true) @RequestBody CanaryAnalysisExecutionRequest canaryAnalysisExecutionRequest, @ApiParam(value="The id for the canary configuration to use for the analysis execution") @PathVariable String canaryConfigId) {
        String resolvedMetricsAccountName = this.accountCredentialsRepository.getRequiredOneBy(metricsAccountName, AccountCredentials.Type.METRICS_STORE).getName();
        String resolvedStorageAccountName = this.accountCredentialsRepository.getRequiredOneBy(storageAccountName, AccountCredentials.Type.OBJECT_STORE).getName();
        String resolvedConfigurationAccountName = this.accountCredentialsRepository.getRequiredOneBy(configurationAccountName, AccountCredentials.Type.CONFIGURATION_STORE).getName();
        StorageService configurationService = this.storageServiceRepository.getRequiredOne(resolvedConfigurationAccountName);
        CanaryConfig canaryConfig = (CanaryConfig)configurationService.loadObject(resolvedConfigurationAccountName, ObjectType.CANARY_CONFIG, canaryConfigId);
        return this.canaryAnalysisService.initiateCanaryAnalysisExecution(CanaryAnalysisConfig.builder().user(Optional.ofNullable(user).orElse("anonymous")).application(Optional.ofNullable(application).orElse("ad-hoc")).parentPipelineExecutionId(parentPipelineExecutionId).canaryConfigId(canaryConfigId).executionRequest(canaryAnalysisExecutionRequest).metricsAccountName(resolvedMetricsAccountName).storageAccountName(resolvedStorageAccountName).configurationAccountName(configurationAccountName).canaryConfig(QueryConfigUtils.escapeTemplates((CanaryConfig)canaryConfig)).build());
    }

    @ApiOperation(value="Initiate an canary analysis execution with multiple canary judgements with the CanaryConfig provided in the request body")
    @RequestMapping(consumes={"application/json"}, method={RequestMethod.POST})
    public CanaryAnalysisExecutionResponse initiateCanaryAnalysisExecutionWithConfig(@ApiParam(value="The initiating user", defaultValue="anonymous", example="justin.field@example.com") @RequestParam(required=false) String user, @ApiParam(value="The application under test", example="examplecanarymicroservice") @RequestParam(required=false) String application, @ApiParam(value="The parent pipeline execution id, if this is being executed as a StageExecution in another pipeline", example="01CYZCD53RBX2KR2Q9GY0218UI") @RequestParam(required=false) String parentPipelineExecutionId, @ApiParam(value="The account that has the metrics for the application under test", example="some-metrics-account") @RequestParam(required=false) String metricsAccountName, @ApiParam(value="The account that will be used to store results", example="some-storage-account") @RequestParam(required=false) String storageAccountName, @ApiParam(required=true) @RequestBody CanaryAnalysisAdhocExecutionRequest canaryAnalysisAdhocExecutionRequest) {
        String resolvedMetricsAccountName = this.accountCredentialsRepository.getRequiredOneBy(metricsAccountName, AccountCredentials.Type.METRICS_STORE).getName();
        String resolvedStorageAccountName = this.accountCredentialsRepository.getRequiredOneBy(storageAccountName, AccountCredentials.Type.OBJECT_STORE).getName();
        if (canaryAnalysisAdhocExecutionRequest.getCanaryConfig() == null) {
            throw new IllegalArgumentException("canaryConfig must be provided for ad-hoc requests");
        }
        if (canaryAnalysisAdhocExecutionRequest.getExecutionRequest() == null) {
            throw new IllegalArgumentException("executionRequest must be provided for ad-hoc requests");
        }
        return this.canaryAnalysisService.initiateCanaryAnalysisExecution(CanaryAnalysisConfig.builder().user(Optional.ofNullable(user).orElse("anonymous")).application(Optional.ofNullable(application).orElse("ad-hoc")).parentPipelineExecutionId(parentPipelineExecutionId).executionRequest(canaryAnalysisAdhocExecutionRequest.getExecutionRequest()).metricsAccountName(resolvedMetricsAccountName).storageAccountName(resolvedStorageAccountName).canaryConfig(QueryConfigUtils.escapeTemplates((CanaryConfig)canaryAnalysisAdhocExecutionRequest.getCanaryConfig())).build());
    }

    @ApiOperation(value="Retrieve status and results for a canary analysis execution")
    @RequestMapping(value={"/{canaryAnalysisExecutionId:.+}"}, method={RequestMethod.GET})
    public CanaryAnalysisExecutionStatusResponse getCanaryAnalysisExecution(@ApiParam(value="The id for the Canary Analysis Execution") @PathVariable String canaryAnalysisExecutionId, @ApiParam(value="The account to use to try and find the execution if not found in the execution repo", example="some-storage-account") @RequestParam(required=false) String storageAccountName) {
        return this.canaryAnalysisService.getCanaryAnalysisExecution(canaryAnalysisExecutionId, storageAccountName);
    }
}

