/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

@ApiModel(description="Defines where to find the metrics for the experiment and control in the metrics source.")
public class CanaryAnalysisExecutionRequestScope {
    @ApiModelProperty(value="Specifies unique name of the metrics scope.", example="default")
    String scopeName;
    @ApiModelProperty(value="This value is used to fetch the data for the control from the metrics service. It is often a server group name (e.g. ASG on EC2 or MIG on GCE).", example="examplemicroservice--control-v001")
    String controlScope;
    @ApiModelProperty(value="This is the location of the control which is used by some metrics sources to further differentiate metrics.Examples include a region or zone.", example="us-west-2")
    String controlLocation;
    @ApiModelProperty(value="The time offset in minutes to be subtracted from the control start and end time. If none is provided, the control is evaluated at the same time as the experiment.", example="10")
    Long controlOffsetInMinutes;
    @ApiModelProperty(value="This value is used to fetch the data for the experiment from the metrics service. It is often a server group name (e.g. ASG on EC2 or MIG on GCE).", example="examplemicroservice--experiment-v001")
    String experimentScope;
    @ApiModelProperty(value="This is the location of the experiment which is used by some metrics sources to further differentiate metrics.Examples include a region or zone.", example="us-west-2")
    String experimentLocation;
    @ApiModelProperty(value="This optional value indicates the start time for looking up metrics. If this value is omitted, the current time at execution will be used instead.", example="2018-12-17T20:56:39.689Z")
    String startTimeIso;
    @ApiModelProperty(value="This value will be used to calculate the length of time of the analysis execution.\nEither this value or lifetime (in the parent object) must be supplied. This field takes precedence over lifetime.", example="2018-12-17T21:56:39.689Z")
    String endTimeIso;
    @ApiModelProperty(value="This indicates the period in seconds for how often data points will be requested from the metrics sources when querying for metrics.\nThe value defaults to 60 which means a data point will be requested every 60 seconds from the data source.\nThe resulting resolution (data points per the calculated interval) needs to be at least 50 in order to produce accurate results.", example="60")
    Long step;
    @ApiModelProperty(value="This is an additional scope to define key values as some metric sources require additional scope params. For example New Relic and SignalFx require _scope_key to be supplied.")
    Map<String, String> extendedScopeParams;

    @JsonIgnore
    public Instant getStartTimeAsInstant() {
        if (this.startTimeIso != null) {
            return Instant.parse(this.startTimeIso);
        }
        return null;
    }

    @JsonIgnore
    public Instant getEndTimeAsInstant() {
        if (this.endTimeIso != null) {
            return Instant.parse(this.endTimeIso);
        }
        return null;
    }

    private static String $default$scopeName() {
        return "default";
    }

    private static Long $default$controlOffsetInMinutes() {
        return 0L;
    }

    private static Long $default$step() {
        return 60L;
    }

    private static Map<String, String> $default$extendedScopeParams() {
        return new HashMap<String, String>();
    }

    public static CanaryAnalysisExecutionRequestScopeBuilder builder() {
        return new CanaryAnalysisExecutionRequestScopeBuilder();
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public String getControlScope() {
        return this.controlScope;
    }

    public String getControlLocation() {
        return this.controlLocation;
    }

    public Long getControlOffsetInMinutes() {
        return this.controlOffsetInMinutes;
    }

    public String getExperimentScope() {
        return this.experimentScope;
    }

    public String getExperimentLocation() {
        return this.experimentLocation;
    }

    public String getStartTimeIso() {
        return this.startTimeIso;
    }

    public String getEndTimeIso() {
        return this.endTimeIso;
    }

    public Long getStep() {
        return this.step;
    }

    public Map<String, String> getExtendedScopeParams() {
        return this.extendedScopeParams;
    }

    public CanaryAnalysisExecutionRequestScope setScopeName(String scopeName) {
        this.scopeName = scopeName;
        return this;
    }

    public CanaryAnalysisExecutionRequestScope setControlScope(String controlScope) {
        this.controlScope = controlScope;
        return this;
    }

    public CanaryAnalysisExecutionRequestScope setControlLocation(String controlLocation) {
        this.controlLocation = controlLocation;
        return this;
    }

    public CanaryAnalysisExecutionRequestScope setControlOffsetInMinutes(Long controlOffsetInMinutes) {
        this.controlOffsetInMinutes = controlOffsetInMinutes;
        return this;
    }

    public CanaryAnalysisExecutionRequestScope setExperimentScope(String experimentScope) {
        this.experimentScope = experimentScope;
        return this;
    }

    public CanaryAnalysisExecutionRequestScope setExperimentLocation(String experimentLocation) {
        this.experimentLocation = experimentLocation;
        return this;
    }

    public CanaryAnalysisExecutionRequestScope setStartTimeIso(String startTimeIso) {
        this.startTimeIso = startTimeIso;
        return this;
    }

    public CanaryAnalysisExecutionRequestScope setEndTimeIso(String endTimeIso) {
        this.endTimeIso = endTimeIso;
        return this;
    }

    public CanaryAnalysisExecutionRequestScope setStep(Long step) {
        this.step = step;
        return this;
    }

    public CanaryAnalysisExecutionRequestScope setExtendedScopeParams(Map<String, String> extendedScopeParams) {
        this.extendedScopeParams = extendedScopeParams;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CanaryAnalysisExecutionRequestScope)) {
            return false;
        }
        CanaryAnalysisExecutionRequestScope other = (CanaryAnalysisExecutionRequestScope)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$controlOffsetInMinutes = this.getControlOffsetInMinutes();
        Long other$controlOffsetInMinutes = other.getControlOffsetInMinutes();
        if (this$controlOffsetInMinutes == null ? other$controlOffsetInMinutes != null : !((Object)this$controlOffsetInMinutes).equals(other$controlOffsetInMinutes)) {
            return false;
        }
        Long this$step = this.getStep();
        Long other$step = other.getStep();
        if (this$step == null ? other$step != null : !((Object)this$step).equals(other$step)) {
            return false;
        }
        String this$scopeName = this.getScopeName();
        String other$scopeName = other.getScopeName();
        if (this$scopeName == null ? other$scopeName != null : !this$scopeName.equals(other$scopeName)) {
            return false;
        }
        String this$controlScope = this.getControlScope();
        String other$controlScope = other.getControlScope();
        if (this$controlScope == null ? other$controlScope != null : !this$controlScope.equals(other$controlScope)) {
            return false;
        }
        String this$controlLocation = this.getControlLocation();
        String other$controlLocation = other.getControlLocation();
        if (this$controlLocation == null ? other$controlLocation != null : !this$controlLocation.equals(other$controlLocation)) {
            return false;
        }
        String this$experimentScope = this.getExperimentScope();
        String other$experimentScope = other.getExperimentScope();
        if (this$experimentScope == null ? other$experimentScope != null : !this$experimentScope.equals(other$experimentScope)) {
            return false;
        }
        String this$experimentLocation = this.getExperimentLocation();
        String other$experimentLocation = other.getExperimentLocation();
        if (this$experimentLocation == null ? other$experimentLocation != null : !this$experimentLocation.equals(other$experimentLocation)) {
            return false;
        }
        String this$startTimeIso = this.getStartTimeIso();
        String other$startTimeIso = other.getStartTimeIso();
        if (this$startTimeIso == null ? other$startTimeIso != null : !this$startTimeIso.equals(other$startTimeIso)) {
            return false;
        }
        String this$endTimeIso = this.getEndTimeIso();
        String other$endTimeIso = other.getEndTimeIso();
        if (this$endTimeIso == null ? other$endTimeIso != null : !this$endTimeIso.equals(other$endTimeIso)) {
            return false;
        }
        Map<String, String> this$extendedScopeParams = this.getExtendedScopeParams();
        Map<String, String> other$extendedScopeParams = other.getExtendedScopeParams();
        return !(this$extendedScopeParams == null ? other$extendedScopeParams != null : !((Object)this$extendedScopeParams).equals(other$extendedScopeParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CanaryAnalysisExecutionRequestScope;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $controlOffsetInMinutes = this.getControlOffsetInMinutes();
        result = result * 59 + ($controlOffsetInMinutes == null ? 43 : ((Object)$controlOffsetInMinutes).hashCode());
        Long $step = this.getStep();
        result = result * 59 + ($step == null ? 43 : ((Object)$step).hashCode());
        String $scopeName = this.getScopeName();
        result = result * 59 + ($scopeName == null ? 43 : $scopeName.hashCode());
        String $controlScope = this.getControlScope();
        result = result * 59 + ($controlScope == null ? 43 : $controlScope.hashCode());
        String $controlLocation = this.getControlLocation();
        result = result * 59 + ($controlLocation == null ? 43 : $controlLocation.hashCode());
        String $experimentScope = this.getExperimentScope();
        result = result * 59 + ($experimentScope == null ? 43 : $experimentScope.hashCode());
        String $experimentLocation = this.getExperimentLocation();
        result = result * 59 + ($experimentLocation == null ? 43 : $experimentLocation.hashCode());
        String $startTimeIso = this.getStartTimeIso();
        result = result * 59 + ($startTimeIso == null ? 43 : $startTimeIso.hashCode());
        String $endTimeIso = this.getEndTimeIso();
        result = result * 59 + ($endTimeIso == null ? 43 : $endTimeIso.hashCode());
        Map<String, String> $extendedScopeParams = this.getExtendedScopeParams();
        result = result * 59 + ($extendedScopeParams == null ? 43 : ((Object)$extendedScopeParams).hashCode());
        return result;
    }

    public String toString() {
        return "CanaryAnalysisExecutionRequestScope(scopeName=" + this.getScopeName() + ", controlScope=" + this.getControlScope() + ", controlLocation=" + this.getControlLocation() + ", controlOffsetInMinutes=" + this.getControlOffsetInMinutes() + ", experimentScope=" + this.getExperimentScope() + ", experimentLocation=" + this.getExperimentLocation() + ", startTimeIso=" + this.getStartTimeIso() + ", endTimeIso=" + this.getEndTimeIso() + ", step=" + this.getStep() + ", extendedScopeParams=" + this.getExtendedScopeParams() + ")";
    }

    public CanaryAnalysisExecutionRequestScope(String scopeName, String controlScope, String controlLocation, Long controlOffsetInMinutes, String experimentScope, String experimentLocation, String startTimeIso, String endTimeIso, Long step, Map<String, String> extendedScopeParams) {
        this.scopeName = scopeName;
        this.controlScope = controlScope;
        this.controlLocation = controlLocation;
        this.controlOffsetInMinutes = controlOffsetInMinutes;
        this.experimentScope = experimentScope;
        this.experimentLocation = experimentLocation;
        this.startTimeIso = startTimeIso;
        this.endTimeIso = endTimeIso;
        this.step = step;
        this.extendedScopeParams = extendedScopeParams;
    }

    public CanaryAnalysisExecutionRequestScope() {
        this.scopeName = CanaryAnalysisExecutionRequestScope.$default$scopeName();
        this.controlOffsetInMinutes = CanaryAnalysisExecutionRequestScope.$default$controlOffsetInMinutes();
        this.step = CanaryAnalysisExecutionRequestScope.$default$step();
        this.extendedScopeParams = CanaryAnalysisExecutionRequestScope.$default$extendedScopeParams();
    }

    public static class CanaryAnalysisExecutionRequestScopeBuilder {
        private boolean scopeName$set;
        private String scopeName$value;
        private String controlScope;
        private String controlLocation;
        private boolean controlOffsetInMinutes$set;
        private Long controlOffsetInMinutes$value;
        private String experimentScope;
        private String experimentLocation;
        private String startTimeIso;
        private String endTimeIso;
        private boolean step$set;
        private Long step$value;
        private boolean extendedScopeParams$set;
        private Map<String, String> extendedScopeParams$value;

        CanaryAnalysisExecutionRequestScopeBuilder() {
        }

        public CanaryAnalysisExecutionRequestScopeBuilder scopeName(String scopeName) {
            this.scopeName$value = scopeName;
            this.scopeName$set = true;
            return this;
        }

        public CanaryAnalysisExecutionRequestScopeBuilder controlScope(String controlScope) {
            this.controlScope = controlScope;
            return this;
        }

        public CanaryAnalysisExecutionRequestScopeBuilder controlLocation(String controlLocation) {
            this.controlLocation = controlLocation;
            return this;
        }

        public CanaryAnalysisExecutionRequestScopeBuilder controlOffsetInMinutes(Long controlOffsetInMinutes) {
            this.controlOffsetInMinutes$value = controlOffsetInMinutes;
            this.controlOffsetInMinutes$set = true;
            return this;
        }

        public CanaryAnalysisExecutionRequestScopeBuilder experimentScope(String experimentScope) {
            this.experimentScope = experimentScope;
            return this;
        }

        public CanaryAnalysisExecutionRequestScopeBuilder experimentLocation(String experimentLocation) {
            this.experimentLocation = experimentLocation;
            return this;
        }

        public CanaryAnalysisExecutionRequestScopeBuilder startTimeIso(String startTimeIso) {
            this.startTimeIso = startTimeIso;
            return this;
        }

        public CanaryAnalysisExecutionRequestScopeBuilder endTimeIso(String endTimeIso) {
            this.endTimeIso = endTimeIso;
            return this;
        }

        public CanaryAnalysisExecutionRequestScopeBuilder step(Long step) {
            this.step$value = step;
            this.step$set = true;
            return this;
        }

        public CanaryAnalysisExecutionRequestScopeBuilder extendedScopeParams(Map<String, String> extendedScopeParams) {
            this.extendedScopeParams$value = extendedScopeParams;
            this.extendedScopeParams$set = true;
            return this;
        }

        public CanaryAnalysisExecutionRequestScope build() {
            String scopeName$value = this.scopeName$value;
            if (!this.scopeName$set) {
                scopeName$value = CanaryAnalysisExecutionRequestScope.$default$scopeName();
            }
            Long controlOffsetInMinutes$value = this.controlOffsetInMinutes$value;
            if (!this.controlOffsetInMinutes$set) {
                controlOffsetInMinutes$value = CanaryAnalysisExecutionRequestScope.$default$controlOffsetInMinutes();
            }
            Long step$value = this.step$value;
            if (!this.step$set) {
                step$value = CanaryAnalysisExecutionRequestScope.$default$step();
            }
            Map<String, String> extendedScopeParams$value = this.extendedScopeParams$value;
            if (!this.extendedScopeParams$set) {
                extendedScopeParams$value = CanaryAnalysisExecutionRequestScope.$default$extendedScopeParams();
            }
            return new CanaryAnalysisExecutionRequestScope(scopeName$value, this.controlScope, this.controlLocation, controlOffsetInMinutes$value, this.experimentScope, this.experimentLocation, this.startTimeIso, this.endTimeIso, step$value, extendedScopeParams$value);
        }

        public String toString() {
            return "CanaryAnalysisExecutionRequestScope.CanaryAnalysisExecutionRequestScopeBuilder(scopeName$value=" + this.scopeName$value + ", controlScope=" + this.controlScope + ", controlLocation=" + this.controlLocation + ", controlOffsetInMinutes$value=" + this.controlOffsetInMinutes$value + ", experimentScope=" + this.experimentScope + ", experimentLocation=" + this.experimentLocation + ", startTimeIso=" + this.startTimeIso + ", endTimeIso=" + this.endTimeIso + ", step$value=" + this.step$value + ", extendedScopeParams$value=" + this.extendedScopeParams$value + ")";
        }
    }
}

