/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.orca.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.netflix.kayenta.canary.CanaryExecutionStatusResponse;
import com.netflix.kayenta.canary.ExecutionMapper;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import com.netflix.kayenta.standalonecanaryanalysis.orca.MonitorKayentaCanaryContext;
import com.netflix.kayenta.standalonecanaryanalysis.orca.Stats;
import com.netflix.spinnaker.orca.api.pipeline.OverridableTimeoutRetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MonitorCanaryTask
implements Task,
OverridableTimeoutRetryableTask {
    private static final Logger log = LoggerFactory.getLogger(MonitorCanaryTask.class);
    public static final String CANARY_EXECUTION_STATUS_RESPONSE = "canaryExecutionStatusResponse";
    private final ExecutionRepository executionRepository;
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final ExecutionMapper executionMapper;

    @Autowired
    public MonitorCanaryTask(ExecutionRepository executionRepository, AccountCredentialsRepository accountCredentialsRepository, ExecutionMapper executionMapper) {
        this.executionRepository = executionRepository;
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.executionMapper = executionMapper;
    }

    public long getBackoffPeriod() {
        return 1000L;
    }

    public long getTimeout() {
        return Duration.ofHours(12L).toMillis();
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        MonitorKayentaCanaryContext context = (MonitorKayentaCanaryContext)stage.mapTo(MonitorKayentaCanaryContext.class);
        PipelineExecution pipeline = this.executionRepository.retrieve(ExecutionType.PIPELINE, context.getCanaryPipelineExecutionId());
        CanaryExecutionStatusResponse statusResponse = this.executionMapper.fromExecution(pipeline);
        ExecutionStatus executionStatus = ExecutionStatus.valueOf((String)statusResponse.getStatus().toUpperCase());
        if (executionStatus == ExecutionStatus.SUCCEEDED) {
            ExecutionStatus resultStatus;
            double canaryScore = statusResponse.getResult().getJudgeResult().getScore().getScore();
            List<String> warnings = this.getResultsWarnings(context, statusResponse);
            HashMap<String, Object> resultContext = new HashMap<String, Object>();
            if (canaryScore <= context.getScoreThresholds().getMarginal()) {
                resultStatus = ExecutionStatus.TERMINAL;
                resultContext.put("canaryScoreMessage", "Canary score is not above the marginal score threshold.");
            } else {
                resultStatus = ExecutionStatus.SUCCEEDED;
            }
            resultContext.put(CANARY_EXECUTION_STATUS_RESPONSE, statusResponse);
            resultContext.put("canaryScore", canaryScore);
            resultContext.put("warnings", warnings);
            return TaskResult.builder((ExecutionStatus)resultStatus).context(resultContext).build();
        }
        if (executionStatus.isHalt()) {
            HashMap<String, Object> resultContext = new HashMap<String, Object>();
            resultContext.put("canaryPipelineStatus", executionStatus);
            if (executionStatus == ExecutionStatus.CANCELED) {
                resultContext.put("exception", ImmutableMap.of((Object)"details", (Object)ImmutableMap.of((Object)"errors", (Object)ImmutableList.of((Object)"Canary execution was canceled."))));
            } else {
                Optional.ofNullable(statusResponse.getException()).ifPresent(exception -> resultContext.put("exception", exception));
            }
            resultContext.put(CANARY_EXECUTION_STATUS_RESPONSE, statusResponse);
            return TaskResult.builder((ExecutionStatus)ExecutionStatus.TERMINAL).context(resultContext).build();
        }
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.RUNNING).context("canaryPipelineStatus", (Object)executionStatus).build();
    }

    protected List<String> getResultsWarnings(MonitorKayentaCanaryContext context, CanaryExecutionStatusResponse statusResponse) {
        Set allCredentials;
        Optional<AccountCredentials> credential;
        LinkedList<String> warnings = new LinkedList<String>();
        String credentialType = "";
        if (context.getMetricsAccountName() != null && (credential = (allCredentials = this.accountCredentialsRepository.getAll()).stream().filter(cred -> cred.getName().equals(context.getMetricsAccountName())).findAny()).isPresent()) {
            credentialType = credential.get().getType();
        }
        ObjectMapper om = new ObjectMapper();
        if (!credentialType.equals("datadog") && statusResponse.getResult().getJudgeResult().getResults().stream().anyMatch(canaryAnalysisResult -> ((Stats)om.convertValue(canaryAnalysisResult.getControlMetadata().get("stats"), Stats.class)).getCount() < 50)) {
            warnings.add("One of the metrics returned fewer than 50 data points, which can reduce confidence in the final canary score.");
        }
        return warnings;
    }
}

