/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.netflix.kayenta.canary.results.CanaryResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.LinkedList;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@ApiModel(description="Summary Result of the Judgement Executions. See GET /canary/${this.executionId} for full result.")
public class CanaryExecutionResult {
    @NotNull
    @ApiModelProperty(value="This is the execution id of the canary judgement which can be used in the canary controller APIs to fetch the full result.")
    protected String executionId;
    @NotNull
    @ApiModelProperty(value="This is the Orca Execution Status for the Canary Judgement Execution.")
    protected ExecutionStatus executionStatus;
    @ApiModelProperty(value="This shows the first exception in the Judgement Execution if any occurred.")
    protected Object exception;
    @ApiModelProperty(value="The result of the canary judgement execution.")
    protected CanaryResult result;
    @ApiModelProperty(value="judgementStartTimeIso is an ISO 8061 string and is the start time used to query the metric source for this judgement.")
    protected String judgementStartTimeIso;
    @ApiModelProperty(value="judgementStartTimeMillis is in epoch millis time and is the start time used to query the metric source for this judgement.")
    protected Long judgementStartTimeMillis;
    @ApiModelProperty(value="judgementEndTimeIso is an ISO 8061 string and is the end time used to query the metric source for this judgement.")
    protected String judgementEndTimeIso;
    @ApiModelProperty(value="judgementEndTimeMillis is in epoch millis time and is the end time used to query the metric source for this judgement.")
    protected Long judgementEndTimeMillis;
    @ApiModelProperty(value="This shows any warnings that occurred during the canary judgement.")
    @NonNull
    List<String> warnings;
    @ApiModelProperty(value="This is the metric set pair list id for this canary judgement execution which can be used for obtaining the raw metrics via the API.")
    protected String metricSetPairListId;
    @ApiModelProperty(value="buildTimeMillis is in epoch millis time and refers to the time the pipeline was first created.")
    protected Long buildTimeMillis;
    @ApiModelProperty(value="buildTimeIso is an ISO 8061 string and refers to the time the pipeline was first created.")
    protected String buildTimeIso;
    @ApiModelProperty(value="startTimeMillis is in epoch millis time and refers to the time the pipeline started running.")
    protected Long startTimeMillis;
    @ApiModelProperty(value="startTimeIso is an ISO 8061 string and refers to the time the pipeline started running.")
    protected String startTimeIso;
    @ApiModelProperty(value="endTimeMillis is in epoch millis time and refers to the time the pipeline ended, either successfully or unsuccessfully.")
    protected Long endTimeMillis;
    @ApiModelProperty(value="endTimeIso is an ISO 8061 string and refers to the time the pipeline ended, either successfully or unsuccessfully.")
    protected String endTimeIso;
    @ApiModelProperty(value="If set, these are the account names used for this run.")
    protected String storageAccountName;
    @ApiModelProperty(value="If set, these are the account names used for this run.")
    protected String configurationAccountName;

    private static List<String> $default$warnings() {
        return new LinkedList<String>();
    }

    public static CanaryExecutionResultBuilder builder() {
        return new CanaryExecutionResultBuilder();
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public Object getException() {
        return this.exception;
    }

    public CanaryResult getResult() {
        return this.result;
    }

    public String getJudgementStartTimeIso() {
        return this.judgementStartTimeIso;
    }

    public Long getJudgementStartTimeMillis() {
        return this.judgementStartTimeMillis;
    }

    public String getJudgementEndTimeIso() {
        return this.judgementEndTimeIso;
    }

    public Long getJudgementEndTimeMillis() {
        return this.judgementEndTimeMillis;
    }

    @NonNull
    public List<String> getWarnings() {
        return this.warnings;
    }

    public String getMetricSetPairListId() {
        return this.metricSetPairListId;
    }

    public Long getBuildTimeMillis() {
        return this.buildTimeMillis;
    }

    public String getBuildTimeIso() {
        return this.buildTimeIso;
    }

    public Long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public String getStartTimeIso() {
        return this.startTimeIso;
    }

    public Long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public String getEndTimeIso() {
        return this.endTimeIso;
    }

    public String getStorageAccountName() {
        return this.storageAccountName;
    }

    public String getConfigurationAccountName() {
        return this.configurationAccountName;
    }

    public CanaryExecutionResult setExecutionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    public CanaryExecutionResult setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
        return this;
    }

    public CanaryExecutionResult setException(Object exception) {
        this.exception = exception;
        return this;
    }

    public CanaryExecutionResult setResult(CanaryResult result) {
        this.result = result;
        return this;
    }

    public CanaryExecutionResult setJudgementStartTimeIso(String judgementStartTimeIso) {
        this.judgementStartTimeIso = judgementStartTimeIso;
        return this;
    }

    public CanaryExecutionResult setJudgementStartTimeMillis(Long judgementStartTimeMillis) {
        this.judgementStartTimeMillis = judgementStartTimeMillis;
        return this;
    }

    public CanaryExecutionResult setJudgementEndTimeIso(String judgementEndTimeIso) {
        this.judgementEndTimeIso = judgementEndTimeIso;
        return this;
    }

    public CanaryExecutionResult setJudgementEndTimeMillis(Long judgementEndTimeMillis) {
        this.judgementEndTimeMillis = judgementEndTimeMillis;
        return this;
    }

    public CanaryExecutionResult setWarnings(@NonNull List<String> warnings) {
        if (warnings == null) {
            throw new IllegalArgumentException("warnings is marked non-null but is null");
        }
        this.warnings = warnings;
        return this;
    }

    public CanaryExecutionResult setMetricSetPairListId(String metricSetPairListId) {
        this.metricSetPairListId = metricSetPairListId;
        return this;
    }

    public CanaryExecutionResult setBuildTimeMillis(Long buildTimeMillis) {
        this.buildTimeMillis = buildTimeMillis;
        return this;
    }

    public CanaryExecutionResult setBuildTimeIso(String buildTimeIso) {
        this.buildTimeIso = buildTimeIso;
        return this;
    }

    public CanaryExecutionResult setStartTimeMillis(Long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
        return this;
    }

    public CanaryExecutionResult setStartTimeIso(String startTimeIso) {
        this.startTimeIso = startTimeIso;
        return this;
    }

    public CanaryExecutionResult setEndTimeMillis(Long endTimeMillis) {
        this.endTimeMillis = endTimeMillis;
        return this;
    }

    public CanaryExecutionResult setEndTimeIso(String endTimeIso) {
        this.endTimeIso = endTimeIso;
        return this;
    }

    public CanaryExecutionResult setStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
        return this;
    }

    public CanaryExecutionResult setConfigurationAccountName(String configurationAccountName) {
        this.configurationAccountName = configurationAccountName;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CanaryExecutionResult)) {
            return false;
        }
        CanaryExecutionResult other = (CanaryExecutionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$judgementStartTimeMillis = this.getJudgementStartTimeMillis();
        Long other$judgementStartTimeMillis = other.getJudgementStartTimeMillis();
        if (this$judgementStartTimeMillis == null ? other$judgementStartTimeMillis != null : !((Object)this$judgementStartTimeMillis).equals(other$judgementStartTimeMillis)) {
            return false;
        }
        Long this$judgementEndTimeMillis = this.getJudgementEndTimeMillis();
        Long other$judgementEndTimeMillis = other.getJudgementEndTimeMillis();
        if (this$judgementEndTimeMillis == null ? other$judgementEndTimeMillis != null : !((Object)this$judgementEndTimeMillis).equals(other$judgementEndTimeMillis)) {
            return false;
        }
        Long this$buildTimeMillis = this.getBuildTimeMillis();
        Long other$buildTimeMillis = other.getBuildTimeMillis();
        if (this$buildTimeMillis == null ? other$buildTimeMillis != null : !((Object)this$buildTimeMillis).equals(other$buildTimeMillis)) {
            return false;
        }
        Long this$startTimeMillis = this.getStartTimeMillis();
        Long other$startTimeMillis = other.getStartTimeMillis();
        if (this$startTimeMillis == null ? other$startTimeMillis != null : !((Object)this$startTimeMillis).equals(other$startTimeMillis)) {
            return false;
        }
        Long this$endTimeMillis = this.getEndTimeMillis();
        Long other$endTimeMillis = other.getEndTimeMillis();
        if (this$endTimeMillis == null ? other$endTimeMillis != null : !((Object)this$endTimeMillis).equals(other$endTimeMillis)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        ExecutionStatus this$executionStatus = this.getExecutionStatus();
        ExecutionStatus other$executionStatus = other.getExecutionStatus();
        if (this$executionStatus == null ? other$executionStatus != null : !this$executionStatus.equals(other$executionStatus)) {
            return false;
        }
        Object this$exception = this.getException();
        Object other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        CanaryResult this$result = this.getResult();
        CanaryResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$judgementStartTimeIso = this.getJudgementStartTimeIso();
        String other$judgementStartTimeIso = other.getJudgementStartTimeIso();
        if (this$judgementStartTimeIso == null ? other$judgementStartTimeIso != null : !this$judgementStartTimeIso.equals(other$judgementStartTimeIso)) {
            return false;
        }
        String this$judgementEndTimeIso = this.getJudgementEndTimeIso();
        String other$judgementEndTimeIso = other.getJudgementEndTimeIso();
        if (this$judgementEndTimeIso == null ? other$judgementEndTimeIso != null : !this$judgementEndTimeIso.equals(other$judgementEndTimeIso)) {
            return false;
        }
        List<String> this$warnings = this.getWarnings();
        List<String> other$warnings = other.getWarnings();
        if (this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings)) {
            return false;
        }
        String this$metricSetPairListId = this.getMetricSetPairListId();
        String other$metricSetPairListId = other.getMetricSetPairListId();
        if (this$metricSetPairListId == null ? other$metricSetPairListId != null : !this$metricSetPairListId.equals(other$metricSetPairListId)) {
            return false;
        }
        String this$buildTimeIso = this.getBuildTimeIso();
        String other$buildTimeIso = other.getBuildTimeIso();
        if (this$buildTimeIso == null ? other$buildTimeIso != null : !this$buildTimeIso.equals(other$buildTimeIso)) {
            return false;
        }
        String this$startTimeIso = this.getStartTimeIso();
        String other$startTimeIso = other.getStartTimeIso();
        if (this$startTimeIso == null ? other$startTimeIso != null : !this$startTimeIso.equals(other$startTimeIso)) {
            return false;
        }
        String this$endTimeIso = this.getEndTimeIso();
        String other$endTimeIso = other.getEndTimeIso();
        if (this$endTimeIso == null ? other$endTimeIso != null : !this$endTimeIso.equals(other$endTimeIso)) {
            return false;
        }
        String this$storageAccountName = this.getStorageAccountName();
        String other$storageAccountName = other.getStorageAccountName();
        if (this$storageAccountName == null ? other$storageAccountName != null : !this$storageAccountName.equals(other$storageAccountName)) {
            return false;
        }
        String this$configurationAccountName = this.getConfigurationAccountName();
        String other$configurationAccountName = other.getConfigurationAccountName();
        return !(this$configurationAccountName == null ? other$configurationAccountName != null : !this$configurationAccountName.equals(other$configurationAccountName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CanaryExecutionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $judgementStartTimeMillis = this.getJudgementStartTimeMillis();
        result = result * 59 + ($judgementStartTimeMillis == null ? 43 : ((Object)$judgementStartTimeMillis).hashCode());
        Long $judgementEndTimeMillis = this.getJudgementEndTimeMillis();
        result = result * 59 + ($judgementEndTimeMillis == null ? 43 : ((Object)$judgementEndTimeMillis).hashCode());
        Long $buildTimeMillis = this.getBuildTimeMillis();
        result = result * 59 + ($buildTimeMillis == null ? 43 : ((Object)$buildTimeMillis).hashCode());
        Long $startTimeMillis = this.getStartTimeMillis();
        result = result * 59 + ($startTimeMillis == null ? 43 : ((Object)$startTimeMillis).hashCode());
        Long $endTimeMillis = this.getEndTimeMillis();
        result = result * 59 + ($endTimeMillis == null ? 43 : ((Object)$endTimeMillis).hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        ExecutionStatus $executionStatus = this.getExecutionStatus();
        result = result * 59 + ($executionStatus == null ? 43 : $executionStatus.hashCode());
        Object $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        CanaryResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $judgementStartTimeIso = this.getJudgementStartTimeIso();
        result = result * 59 + ($judgementStartTimeIso == null ? 43 : $judgementStartTimeIso.hashCode());
        String $judgementEndTimeIso = this.getJudgementEndTimeIso();
        result = result * 59 + ($judgementEndTimeIso == null ? 43 : $judgementEndTimeIso.hashCode());
        List<String> $warnings = this.getWarnings();
        result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
        String $metricSetPairListId = this.getMetricSetPairListId();
        result = result * 59 + ($metricSetPairListId == null ? 43 : $metricSetPairListId.hashCode());
        String $buildTimeIso = this.getBuildTimeIso();
        result = result * 59 + ($buildTimeIso == null ? 43 : $buildTimeIso.hashCode());
        String $startTimeIso = this.getStartTimeIso();
        result = result * 59 + ($startTimeIso == null ? 43 : $startTimeIso.hashCode());
        String $endTimeIso = this.getEndTimeIso();
        result = result * 59 + ($endTimeIso == null ? 43 : $endTimeIso.hashCode());
        String $storageAccountName = this.getStorageAccountName();
        result = result * 59 + ($storageAccountName == null ? 43 : $storageAccountName.hashCode());
        String $configurationAccountName = this.getConfigurationAccountName();
        result = result * 59 + ($configurationAccountName == null ? 43 : $configurationAccountName.hashCode());
        return result;
    }

    public String toString() {
        return "CanaryExecutionResult(executionId=" + this.getExecutionId() + ", executionStatus=" + this.getExecutionStatus() + ", exception=" + this.getException() + ", result=" + this.getResult() + ", judgementStartTimeIso=" + this.getJudgementStartTimeIso() + ", judgementStartTimeMillis=" + this.getJudgementStartTimeMillis() + ", judgementEndTimeIso=" + this.getJudgementEndTimeIso() + ", judgementEndTimeMillis=" + this.getJudgementEndTimeMillis() + ", warnings=" + this.getWarnings() + ", metricSetPairListId=" + this.getMetricSetPairListId() + ", buildTimeMillis=" + this.getBuildTimeMillis() + ", buildTimeIso=" + this.getBuildTimeIso() + ", startTimeMillis=" + this.getStartTimeMillis() + ", startTimeIso=" + this.getStartTimeIso() + ", endTimeMillis=" + this.getEndTimeMillis() + ", endTimeIso=" + this.getEndTimeIso() + ", storageAccountName=" + this.getStorageAccountName() + ", configurationAccountName=" + this.getConfigurationAccountName() + ")";
    }

    public CanaryExecutionResult() {
        this.warnings = CanaryExecutionResult.$default$warnings();
    }

    public CanaryExecutionResult(String executionId, ExecutionStatus executionStatus, Object exception, CanaryResult result, String judgementStartTimeIso, Long judgementStartTimeMillis, String judgementEndTimeIso, Long judgementEndTimeMillis, @NonNull List<String> warnings, String metricSetPairListId, Long buildTimeMillis, String buildTimeIso, Long startTimeMillis, String startTimeIso, Long endTimeMillis, String endTimeIso, String storageAccountName, String configurationAccountName) {
        if (warnings == null) {
            throw new IllegalArgumentException("warnings is marked non-null but is null");
        }
        this.executionId = executionId;
        this.executionStatus = executionStatus;
        this.exception = exception;
        this.result = result;
        this.judgementStartTimeIso = judgementStartTimeIso;
        this.judgementStartTimeMillis = judgementStartTimeMillis;
        this.judgementEndTimeIso = judgementEndTimeIso;
        this.judgementEndTimeMillis = judgementEndTimeMillis;
        this.warnings = warnings;
        this.metricSetPairListId = metricSetPairListId;
        this.buildTimeMillis = buildTimeMillis;
        this.buildTimeIso = buildTimeIso;
        this.startTimeMillis = startTimeMillis;
        this.startTimeIso = startTimeIso;
        this.endTimeMillis = endTimeMillis;
        this.endTimeIso = endTimeIso;
        this.storageAccountName = storageAccountName;
        this.configurationAccountName = configurationAccountName;
    }

    public static class CanaryExecutionResultBuilder {
        private String executionId;
        private ExecutionStatus executionStatus;
        private Object exception;
        private CanaryResult result;
        private String judgementStartTimeIso;
        private Long judgementStartTimeMillis;
        private String judgementEndTimeIso;
        private Long judgementEndTimeMillis;
        private boolean warnings$set;
        private List<String> warnings$value;
        private String metricSetPairListId;
        private Long buildTimeMillis;
        private String buildTimeIso;
        private Long startTimeMillis;
        private String startTimeIso;
        private Long endTimeMillis;
        private String endTimeIso;
        private String storageAccountName;
        private String configurationAccountName;

        CanaryExecutionResultBuilder() {
        }

        public CanaryExecutionResultBuilder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public CanaryExecutionResultBuilder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        public CanaryExecutionResultBuilder exception(Object exception) {
            this.exception = exception;
            return this;
        }

        public CanaryExecutionResultBuilder result(CanaryResult result) {
            this.result = result;
            return this;
        }

        public CanaryExecutionResultBuilder judgementStartTimeIso(String judgementStartTimeIso) {
            this.judgementStartTimeIso = judgementStartTimeIso;
            return this;
        }

        public CanaryExecutionResultBuilder judgementStartTimeMillis(Long judgementStartTimeMillis) {
            this.judgementStartTimeMillis = judgementStartTimeMillis;
            return this;
        }

        public CanaryExecutionResultBuilder judgementEndTimeIso(String judgementEndTimeIso) {
            this.judgementEndTimeIso = judgementEndTimeIso;
            return this;
        }

        public CanaryExecutionResultBuilder judgementEndTimeMillis(Long judgementEndTimeMillis) {
            this.judgementEndTimeMillis = judgementEndTimeMillis;
            return this;
        }

        public CanaryExecutionResultBuilder warnings(@NonNull List<String> warnings) {
            if (warnings == null) {
                throw new IllegalArgumentException("warnings is marked non-null but is null");
            }
            this.warnings$value = warnings;
            this.warnings$set = true;
            return this;
        }

        public CanaryExecutionResultBuilder metricSetPairListId(String metricSetPairListId) {
            this.metricSetPairListId = metricSetPairListId;
            return this;
        }

        public CanaryExecutionResultBuilder buildTimeMillis(Long buildTimeMillis) {
            this.buildTimeMillis = buildTimeMillis;
            return this;
        }

        public CanaryExecutionResultBuilder buildTimeIso(String buildTimeIso) {
            this.buildTimeIso = buildTimeIso;
            return this;
        }

        public CanaryExecutionResultBuilder startTimeMillis(Long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            return this;
        }

        public CanaryExecutionResultBuilder startTimeIso(String startTimeIso) {
            this.startTimeIso = startTimeIso;
            return this;
        }

        public CanaryExecutionResultBuilder endTimeMillis(Long endTimeMillis) {
            this.endTimeMillis = endTimeMillis;
            return this;
        }

        public CanaryExecutionResultBuilder endTimeIso(String endTimeIso) {
            this.endTimeIso = endTimeIso;
            return this;
        }

        public CanaryExecutionResultBuilder storageAccountName(String storageAccountName) {
            this.storageAccountName = storageAccountName;
            return this;
        }

        public CanaryExecutionResultBuilder configurationAccountName(String configurationAccountName) {
            this.configurationAccountName = configurationAccountName;
            return this;
        }

        public CanaryExecutionResult build() {
            List<String> warnings$value = this.warnings$value;
            if (!this.warnings$set) {
                warnings$value = CanaryExecutionResult.$default$warnings();
            }
            return new CanaryExecutionResult(this.executionId, this.executionStatus, this.exception, this.result, this.judgementStartTimeIso, this.judgementStartTimeMillis, this.judgementEndTimeIso, this.judgementEndTimeMillis, warnings$value, this.metricSetPairListId, this.buildTimeMillis, this.buildTimeIso, this.startTimeMillis, this.startTimeIso, this.endTimeMillis, this.endTimeIso, this.storageAccountName, this.configurationAccountName);
        }

        public String toString() {
            return "CanaryExecutionResult.CanaryExecutionResultBuilder(executionId=" + this.executionId + ", executionStatus=" + this.executionStatus + ", exception=" + this.exception + ", result=" + this.result + ", judgementStartTimeIso=" + this.judgementStartTimeIso + ", judgementStartTimeMillis=" + this.judgementStartTimeMillis + ", judgementEndTimeIso=" + this.judgementEndTimeIso + ", judgementEndTimeMillis=" + this.judgementEndTimeMillis + ", warnings$value=" + this.warnings$value + ", metricSetPairListId=" + this.metricSetPairListId + ", buildTimeMillis=" + this.buildTimeMillis + ", buildTimeIso=" + this.buildTimeIso + ", startTimeMillis=" + this.startTimeMillis + ", startTimeIso=" + this.startTimeIso + ", endTimeMillis=" + this.endTimeMillis + ", endTimeIso=" + this.endTimeIso + ", storageAccountName=" + this.storageAccountName + ", configurationAccountName=" + this.configurationAccountName + ")";
        }
    }
}

