/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.orca.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.kayenta.canary.CanaryAdhocExecutionRequest;
import com.netflix.kayenta.canary.CanaryExecutionRequest;
import com.netflix.kayenta.canary.CanaryExecutionResponse;
import com.netflix.kayenta.canary.CanaryScopePair;
import com.netflix.kayenta.canary.ExecutionMapper;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import com.netflix.kayenta.standalonecanaryanalysis.orca.RunCanaryContext;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class RunCanaryTask
implements Task {
    private static final Logger log = LoggerFactory.getLogger(RunCanaryTask.class);
    private final String AD_HOC = "ad-hoc";
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final ExecutionMapper executionMapper;
    private final ObjectMapper kayentaObjectMapper;

    @Lazy
    @Autowired
    public RunCanaryTask(AccountCredentialsRepository accountCredentialsRepository, ExecutionMapper executionMapper, ObjectMapper kayentaObjectMapper) {
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.executionMapper = executionMapper;
        this.kayentaObjectMapper = kayentaObjectMapper;
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        CanaryExecutionResponse canaryExecutionResponse;
        RunCanaryContext context = (RunCanaryContext)this.kayentaObjectMapper.convertValue((Object)stage.getContext(), RunCanaryContext.class);
        String metricsAccount = context.getMetricsAccountName();
        String storageAccount = context.getStorageAccountName();
        CanaryAdhocExecutionRequest request = new CanaryAdhocExecutionRequest();
        request.setCanaryConfig(context.getCanaryConfig());
        CanaryExecutionRequest executionRequest = CanaryExecutionRequest.builder().scopes(context.getScopes()).thresholds(context.getScoreThresholds()).siteLocal(context.getSiteLocal()).build();
        request.setExecutionRequest(executionRequest);
        try {
            String resolvedMetricsAccountName = this.accountCredentialsRepository.getRequiredOneBy(metricsAccount, AccountCredentials.Type.METRICS_STORE).getName();
            String resolvedStorageAccountName = this.accountCredentialsRepository.getRequiredOneBy(storageAccount, AccountCredentials.Type.OBJECT_STORE).getName();
            if (request.getCanaryConfig() == null) {
                throw new IllegalArgumentException("canaryConfig must be provided for ad-hoc requests");
            }
            if (request.getExecutionRequest() == null) {
                throw new IllegalArgumentException("executionRequest must be provided for ad-hoc requests");
            }
            canaryExecutionResponse = this.executionMapper.buildExecution(Optional.ofNullable(context.getApplication()).orElse("ad-hoc"), context.getParentPipelineExecutionId(), Optional.ofNullable(context.getCanaryConfigId()).orElse("ad-hoc"), request.getCanaryConfig(), null, resolvedMetricsAccountName, resolvedStorageAccountName, request.getExecutionRequest());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initiate canary analysis", e);
        }
        String canaryPipelineExecutionId = canaryExecutionResponse.getCanaryExecutionId();
        CanaryScopePair firstScopePair = (CanaryScopePair)((Map.Entry)context.getScopes().entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("There should be at least 1 scope"))).getValue();
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context("canaryPipelineExecutionId", (Object)canaryPipelineExecutionId).context("judgementStartTimeIso", (Object)firstScopePair.getControlScope().getStart().toString()).context("judgementStartTimeMillis", (Object)firstScopePair.getControlScope().getStart().toEpochMilli()).context("judgementEndTimeIso", (Object)firstScopePair.getControlScope().getEnd().toString()).context("judgementEndTimeMillis", (Object)firstScopePair.getControlScope().getEnd().toEpochMilli()).build();
    }
}

