/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.kayenta.canary.CanaryConfig;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionRequest;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionResult;
import com.netflix.kayenta.standalonecanaryanalysis.domain.StageMetadata;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.constraints.NotNull;

@Schema(description="The canary analysis execution status response.")
public class CanaryAnalysisExecutionStatusResponse {
    @NotNull
    @Schema(description="The application under test.")
    protected String application;
    @NotNull
    @Schema(description="This is the initiating user. If none was supplied this will be anonymous.")
    protected String user;
    @Schema(description="This is the parent pipeline execution id if one was provided.")
    protected String parentPipelineExecutionId;
    @NotNull
    @Schema(description="This is the pipeline id of this execution.")
    protected String pipelineId;
    @NotNull
    @Schema(description="This is a map of StageExecution statuses which is useful for gaining insight into progress of the execution.")
    protected List<StageMetadata> stageStatus;
    @NotNull
    @Schema(description="This indicates that the task/stage/pipeline has finished its work, independent of whether it was successful.")
    protected Boolean complete;
    @NotNull
    @Schema(description="This is the Orca Execution Status for the Canary Analysis Pipeline Execution.")
    protected ExecutionStatus executionStatus;
    @Schema(description="This shows the first exception if any occurred.")
    protected Object exception;
    @Schema(description="This is the actual result of the canary analysis execution which will be present when complete is true.")
    protected CanaryAnalysisExecutionResult canaryAnalysisExecutionResult;
    @Schema(description="The supplied request configuration.")
    protected CanaryAnalysisExecutionRequest canaryAnalysisExecutionRequest;
    @Schema(description="The supplied or retrieved canary configuration used.")
    protected CanaryConfig canaryConfig;
    @Schema(description="This is the supplied canary config id if one was provided.")
    protected String canaryConfigId;
    @Schema(description="buildTimeMillis is in epoch millis time and refers to the time the pipeline was first created.")
    protected Long buildTimeMillis;
    @Schema(description="buildTimeIso is an ISO 8061 string and refers to the time the pipeline was first created.")
    protected String buildTimeIso;
    @Schema(description="startTimeIso is an ISO 8061 string and refers to the time the pipeline started running.")
    protected Long startTimeMillis;
    @Schema(description="startTimeIso is an ISO 8061 string and refers to the time the pipeline started running.")
    protected String startTimeIso;
    @Schema(description="endTimeMillis is in epoch millis time and refers to the time the pipeline ended, either successfully or unsuccessfully.")
    protected Long endTimeMillis;
    @Schema(description="endTimeIso is an ISO 8061 string and refers to the time the pipeline ended, either successfully or unsuccessfully.")
    protected String endTimeIso;
    @NotNull
    @Schema(description="The resolved storage account name.")
    protected String storageAccountName;
    @NotNull
    @Schema(description="The resolved metrics account name.")
    protected String metricsAccountName;

    @JsonProperty(value="status")
    @Schema(description="This is the lowercased serialized Orca status which is similar to the status in the /canary endpoints.")
    public String status() {
        return this.executionStatus.toString().toLowerCase();
    }

    public static CanaryAnalysisExecutionStatusResponseBuilder builder() {
        return new CanaryAnalysisExecutionStatusResponseBuilder();
    }

    public String getApplication() {
        return this.application;
    }

    public String getUser() {
        return this.user;
    }

    public String getParentPipelineExecutionId() {
        return this.parentPipelineExecutionId;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public List<StageMetadata> getStageStatus() {
        return this.stageStatus;
    }

    public Boolean getComplete() {
        return this.complete;
    }

    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public Object getException() {
        return this.exception;
    }

    public CanaryAnalysisExecutionResult getCanaryAnalysisExecutionResult() {
        return this.canaryAnalysisExecutionResult;
    }

    public CanaryAnalysisExecutionRequest getCanaryAnalysisExecutionRequest() {
        return this.canaryAnalysisExecutionRequest;
    }

    public CanaryConfig getCanaryConfig() {
        return this.canaryConfig;
    }

    public String getCanaryConfigId() {
        return this.canaryConfigId;
    }

    public Long getBuildTimeMillis() {
        return this.buildTimeMillis;
    }

    public String getBuildTimeIso() {
        return this.buildTimeIso;
    }

    public Long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public String getStartTimeIso() {
        return this.startTimeIso;
    }

    public Long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public String getEndTimeIso() {
        return this.endTimeIso;
    }

    public String getStorageAccountName() {
        return this.storageAccountName;
    }

    public String getMetricsAccountName() {
        return this.metricsAccountName;
    }

    public CanaryAnalysisExecutionStatusResponse setApplication(String application) {
        this.application = application;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setUser(String user) {
        this.user = user;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setParentPipelineExecutionId(String parentPipelineExecutionId) {
        this.parentPipelineExecutionId = parentPipelineExecutionId;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setStageStatus(List<StageMetadata> stageStatus) {
        this.stageStatus = stageStatus;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setComplete(Boolean complete) {
        this.complete = complete;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setException(Object exception) {
        this.exception = exception;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setCanaryAnalysisExecutionResult(CanaryAnalysisExecutionResult canaryAnalysisExecutionResult) {
        this.canaryAnalysisExecutionResult = canaryAnalysisExecutionResult;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setCanaryAnalysisExecutionRequest(CanaryAnalysisExecutionRequest canaryAnalysisExecutionRequest) {
        this.canaryAnalysisExecutionRequest = canaryAnalysisExecutionRequest;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setCanaryConfig(CanaryConfig canaryConfig) {
        this.canaryConfig = canaryConfig;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setCanaryConfigId(String canaryConfigId) {
        this.canaryConfigId = canaryConfigId;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setBuildTimeMillis(Long buildTimeMillis) {
        this.buildTimeMillis = buildTimeMillis;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setBuildTimeIso(String buildTimeIso) {
        this.buildTimeIso = buildTimeIso;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setStartTimeMillis(Long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setStartTimeIso(String startTimeIso) {
        this.startTimeIso = startTimeIso;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setEndTimeMillis(Long endTimeMillis) {
        this.endTimeMillis = endTimeMillis;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setEndTimeIso(String endTimeIso) {
        this.endTimeIso = endTimeIso;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
        return this;
    }

    public CanaryAnalysisExecutionStatusResponse setMetricsAccountName(String metricsAccountName) {
        this.metricsAccountName = metricsAccountName;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CanaryAnalysisExecutionStatusResponse)) {
            return false;
        }
        CanaryAnalysisExecutionStatusResponse other = (CanaryAnalysisExecutionStatusResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$complete = this.getComplete();
        Boolean other$complete = other.getComplete();
        if (this$complete == null ? other$complete != null : !((Object)this$complete).equals(other$complete)) {
            return false;
        }
        Long this$buildTimeMillis = this.getBuildTimeMillis();
        Long other$buildTimeMillis = other.getBuildTimeMillis();
        if (this$buildTimeMillis == null ? other$buildTimeMillis != null : !((Object)this$buildTimeMillis).equals(other$buildTimeMillis)) {
            return false;
        }
        Long this$startTimeMillis = this.getStartTimeMillis();
        Long other$startTimeMillis = other.getStartTimeMillis();
        if (this$startTimeMillis == null ? other$startTimeMillis != null : !((Object)this$startTimeMillis).equals(other$startTimeMillis)) {
            return false;
        }
        Long this$endTimeMillis = this.getEndTimeMillis();
        Long other$endTimeMillis = other.getEndTimeMillis();
        if (this$endTimeMillis == null ? other$endTimeMillis != null : !((Object)this$endTimeMillis).equals(other$endTimeMillis)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$parentPipelineExecutionId = this.getParentPipelineExecutionId();
        String other$parentPipelineExecutionId = other.getParentPipelineExecutionId();
        if (this$parentPipelineExecutionId == null ? other$parentPipelineExecutionId != null : !this$parentPipelineExecutionId.equals(other$parentPipelineExecutionId)) {
            return false;
        }
        String this$pipelineId = this.getPipelineId();
        String other$pipelineId = other.getPipelineId();
        if (this$pipelineId == null ? other$pipelineId != null : !this$pipelineId.equals(other$pipelineId)) {
            return false;
        }
        List<StageMetadata> this$stageStatus = this.getStageStatus();
        List<StageMetadata> other$stageStatus = other.getStageStatus();
        if (this$stageStatus == null ? other$stageStatus != null : !((Object)this$stageStatus).equals(other$stageStatus)) {
            return false;
        }
        ExecutionStatus this$executionStatus = this.getExecutionStatus();
        ExecutionStatus other$executionStatus = other.getExecutionStatus();
        if (this$executionStatus == null ? other$executionStatus != null : !this$executionStatus.equals(other$executionStatus)) {
            return false;
        }
        Object this$exception = this.getException();
        Object other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        CanaryAnalysisExecutionResult this$canaryAnalysisExecutionResult = this.getCanaryAnalysisExecutionResult();
        CanaryAnalysisExecutionResult other$canaryAnalysisExecutionResult = other.getCanaryAnalysisExecutionResult();
        if (this$canaryAnalysisExecutionResult == null ? other$canaryAnalysisExecutionResult != null : !((Object)this$canaryAnalysisExecutionResult).equals(other$canaryAnalysisExecutionResult)) {
            return false;
        }
        CanaryAnalysisExecutionRequest this$canaryAnalysisExecutionRequest = this.getCanaryAnalysisExecutionRequest();
        CanaryAnalysisExecutionRequest other$canaryAnalysisExecutionRequest = other.getCanaryAnalysisExecutionRequest();
        if (this$canaryAnalysisExecutionRequest == null ? other$canaryAnalysisExecutionRequest != null : !((Object)this$canaryAnalysisExecutionRequest).equals(other$canaryAnalysisExecutionRequest)) {
            return false;
        }
        CanaryConfig this$canaryConfig = this.getCanaryConfig();
        CanaryConfig other$canaryConfig = other.getCanaryConfig();
        if (this$canaryConfig == null ? other$canaryConfig != null : !this$canaryConfig.equals(other$canaryConfig)) {
            return false;
        }
        String this$canaryConfigId = this.getCanaryConfigId();
        String other$canaryConfigId = other.getCanaryConfigId();
        if (this$canaryConfigId == null ? other$canaryConfigId != null : !this$canaryConfigId.equals(other$canaryConfigId)) {
            return false;
        }
        String this$buildTimeIso = this.getBuildTimeIso();
        String other$buildTimeIso = other.getBuildTimeIso();
        if (this$buildTimeIso == null ? other$buildTimeIso != null : !this$buildTimeIso.equals(other$buildTimeIso)) {
            return false;
        }
        String this$startTimeIso = this.getStartTimeIso();
        String other$startTimeIso = other.getStartTimeIso();
        if (this$startTimeIso == null ? other$startTimeIso != null : !this$startTimeIso.equals(other$startTimeIso)) {
            return false;
        }
        String this$endTimeIso = this.getEndTimeIso();
        String other$endTimeIso = other.getEndTimeIso();
        if (this$endTimeIso == null ? other$endTimeIso != null : !this$endTimeIso.equals(other$endTimeIso)) {
            return false;
        }
        String this$storageAccountName = this.getStorageAccountName();
        String other$storageAccountName = other.getStorageAccountName();
        if (this$storageAccountName == null ? other$storageAccountName != null : !this$storageAccountName.equals(other$storageAccountName)) {
            return false;
        }
        String this$metricsAccountName = this.getMetricsAccountName();
        String other$metricsAccountName = other.getMetricsAccountName();
        return !(this$metricsAccountName == null ? other$metricsAccountName != null : !this$metricsAccountName.equals(other$metricsAccountName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CanaryAnalysisExecutionStatusResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $complete = this.getComplete();
        result = result * 59 + ($complete == null ? 43 : ((Object)$complete).hashCode());
        Long $buildTimeMillis = this.getBuildTimeMillis();
        result = result * 59 + ($buildTimeMillis == null ? 43 : ((Object)$buildTimeMillis).hashCode());
        Long $startTimeMillis = this.getStartTimeMillis();
        result = result * 59 + ($startTimeMillis == null ? 43 : ((Object)$startTimeMillis).hashCode());
        Long $endTimeMillis = this.getEndTimeMillis();
        result = result * 59 + ($endTimeMillis == null ? 43 : ((Object)$endTimeMillis).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $parentPipelineExecutionId = this.getParentPipelineExecutionId();
        result = result * 59 + ($parentPipelineExecutionId == null ? 43 : $parentPipelineExecutionId.hashCode());
        String $pipelineId = this.getPipelineId();
        result = result * 59 + ($pipelineId == null ? 43 : $pipelineId.hashCode());
        List<StageMetadata> $stageStatus = this.getStageStatus();
        result = result * 59 + ($stageStatus == null ? 43 : ((Object)$stageStatus).hashCode());
        ExecutionStatus $executionStatus = this.getExecutionStatus();
        result = result * 59 + ($executionStatus == null ? 43 : $executionStatus.hashCode());
        Object $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        CanaryAnalysisExecutionResult $canaryAnalysisExecutionResult = this.getCanaryAnalysisExecutionResult();
        result = result * 59 + ($canaryAnalysisExecutionResult == null ? 43 : ((Object)$canaryAnalysisExecutionResult).hashCode());
        CanaryAnalysisExecutionRequest $canaryAnalysisExecutionRequest = this.getCanaryAnalysisExecutionRequest();
        result = result * 59 + ($canaryAnalysisExecutionRequest == null ? 43 : ((Object)$canaryAnalysisExecutionRequest).hashCode());
        CanaryConfig $canaryConfig = this.getCanaryConfig();
        result = result * 59 + ($canaryConfig == null ? 43 : $canaryConfig.hashCode());
        String $canaryConfigId = this.getCanaryConfigId();
        result = result * 59 + ($canaryConfigId == null ? 43 : $canaryConfigId.hashCode());
        String $buildTimeIso = this.getBuildTimeIso();
        result = result * 59 + ($buildTimeIso == null ? 43 : $buildTimeIso.hashCode());
        String $startTimeIso = this.getStartTimeIso();
        result = result * 59 + ($startTimeIso == null ? 43 : $startTimeIso.hashCode());
        String $endTimeIso = this.getEndTimeIso();
        result = result * 59 + ($endTimeIso == null ? 43 : $endTimeIso.hashCode());
        String $storageAccountName = this.getStorageAccountName();
        result = result * 59 + ($storageAccountName == null ? 43 : $storageAccountName.hashCode());
        String $metricsAccountName = this.getMetricsAccountName();
        result = result * 59 + ($metricsAccountName == null ? 43 : $metricsAccountName.hashCode());
        return result;
    }

    public String toString() {
        return "CanaryAnalysisExecutionStatusResponse(application=" + this.getApplication() + ", user=" + this.getUser() + ", parentPipelineExecutionId=" + this.getParentPipelineExecutionId() + ", pipelineId=" + this.getPipelineId() + ", stageStatus=" + String.valueOf(this.getStageStatus()) + ", complete=" + this.getComplete() + ", executionStatus=" + String.valueOf(this.getExecutionStatus()) + ", exception=" + String.valueOf(this.getException()) + ", canaryAnalysisExecutionResult=" + String.valueOf(this.getCanaryAnalysisExecutionResult()) + ", canaryAnalysisExecutionRequest=" + String.valueOf(this.getCanaryAnalysisExecutionRequest()) + ", canaryConfig=" + String.valueOf(this.getCanaryConfig()) + ", canaryConfigId=" + this.getCanaryConfigId() + ", buildTimeMillis=" + this.getBuildTimeMillis() + ", buildTimeIso=" + this.getBuildTimeIso() + ", startTimeMillis=" + this.getStartTimeMillis() + ", startTimeIso=" + this.getStartTimeIso() + ", endTimeMillis=" + this.getEndTimeMillis() + ", endTimeIso=" + this.getEndTimeIso() + ", storageAccountName=" + this.getStorageAccountName() + ", metricsAccountName=" + this.getMetricsAccountName() + ")";
    }

    public CanaryAnalysisExecutionStatusResponse() {
    }

    public CanaryAnalysisExecutionStatusResponse(String application, String user, String parentPipelineExecutionId, String pipelineId, List<StageMetadata> stageStatus, Boolean complete, ExecutionStatus executionStatus, Object exception, CanaryAnalysisExecutionResult canaryAnalysisExecutionResult, CanaryAnalysisExecutionRequest canaryAnalysisExecutionRequest, CanaryConfig canaryConfig, String canaryConfigId, Long buildTimeMillis, String buildTimeIso, Long startTimeMillis, String startTimeIso, Long endTimeMillis, String endTimeIso, String storageAccountName, String metricsAccountName) {
        this.application = application;
        this.user = user;
        this.parentPipelineExecutionId = parentPipelineExecutionId;
        this.pipelineId = pipelineId;
        this.stageStatus = stageStatus;
        this.complete = complete;
        this.executionStatus = executionStatus;
        this.exception = exception;
        this.canaryAnalysisExecutionResult = canaryAnalysisExecutionResult;
        this.canaryAnalysisExecutionRequest = canaryAnalysisExecutionRequest;
        this.canaryConfig = canaryConfig;
        this.canaryConfigId = canaryConfigId;
        this.buildTimeMillis = buildTimeMillis;
        this.buildTimeIso = buildTimeIso;
        this.startTimeMillis = startTimeMillis;
        this.startTimeIso = startTimeIso;
        this.endTimeMillis = endTimeMillis;
        this.endTimeIso = endTimeIso;
        this.storageAccountName = storageAccountName;
        this.metricsAccountName = metricsAccountName;
    }

    public static class CanaryAnalysisExecutionStatusResponseBuilder {
        private String application;
        private String user;
        private String parentPipelineExecutionId;
        private String pipelineId;
        private List<StageMetadata> stageStatus;
        private Boolean complete;
        private ExecutionStatus executionStatus;
        private Object exception;
        private CanaryAnalysisExecutionResult canaryAnalysisExecutionResult;
        private CanaryAnalysisExecutionRequest canaryAnalysisExecutionRequest;
        private CanaryConfig canaryConfig;
        private String canaryConfigId;
        private Long buildTimeMillis;
        private String buildTimeIso;
        private Long startTimeMillis;
        private String startTimeIso;
        private Long endTimeMillis;
        private String endTimeIso;
        private String storageAccountName;
        private String metricsAccountName;

        CanaryAnalysisExecutionStatusResponseBuilder() {
        }

        public CanaryAnalysisExecutionStatusResponseBuilder application(String application) {
            this.application = application;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder user(String user) {
            this.user = user;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder parentPipelineExecutionId(String parentPipelineExecutionId) {
            this.parentPipelineExecutionId = parentPipelineExecutionId;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder stageStatus(List<StageMetadata> stageStatus) {
            this.stageStatus = stageStatus;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder complete(Boolean complete) {
            this.complete = complete;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder exception(Object exception) {
            this.exception = exception;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder canaryAnalysisExecutionResult(CanaryAnalysisExecutionResult canaryAnalysisExecutionResult) {
            this.canaryAnalysisExecutionResult = canaryAnalysisExecutionResult;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder canaryAnalysisExecutionRequest(CanaryAnalysisExecutionRequest canaryAnalysisExecutionRequest) {
            this.canaryAnalysisExecutionRequest = canaryAnalysisExecutionRequest;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder canaryConfig(CanaryConfig canaryConfig) {
            this.canaryConfig = canaryConfig;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder canaryConfigId(String canaryConfigId) {
            this.canaryConfigId = canaryConfigId;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder buildTimeMillis(Long buildTimeMillis) {
            this.buildTimeMillis = buildTimeMillis;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder buildTimeIso(String buildTimeIso) {
            this.buildTimeIso = buildTimeIso;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder startTimeMillis(Long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder startTimeIso(String startTimeIso) {
            this.startTimeIso = startTimeIso;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder endTimeMillis(Long endTimeMillis) {
            this.endTimeMillis = endTimeMillis;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder endTimeIso(String endTimeIso) {
            this.endTimeIso = endTimeIso;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder storageAccountName(String storageAccountName) {
            this.storageAccountName = storageAccountName;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponseBuilder metricsAccountName(String metricsAccountName) {
            this.metricsAccountName = metricsAccountName;
            return this;
        }

        public CanaryAnalysisExecutionStatusResponse build() {
            return new CanaryAnalysisExecutionStatusResponse(this.application, this.user, this.parentPipelineExecutionId, this.pipelineId, this.stageStatus, this.complete, this.executionStatus, this.exception, this.canaryAnalysisExecutionResult, this.canaryAnalysisExecutionRequest, this.canaryConfig, this.canaryConfigId, this.buildTimeMillis, this.buildTimeIso, this.startTimeMillis, this.startTimeIso, this.endTimeMillis, this.endTimeIso, this.storageAccountName, this.metricsAccountName);
        }

        public String toString() {
            return "CanaryAnalysisExecutionStatusResponse.CanaryAnalysisExecutionStatusResponseBuilder(application=" + this.application + ", user=" + this.user + ", parentPipelineExecutionId=" + this.parentPipelineExecutionId + ", pipelineId=" + this.pipelineId + ", stageStatus=" + String.valueOf(this.stageStatus) + ", complete=" + this.complete + ", executionStatus=" + String.valueOf(this.executionStatus) + ", exception=" + String.valueOf(this.exception) + ", canaryAnalysisExecutionResult=" + String.valueOf(this.canaryAnalysisExecutionResult) + ", canaryAnalysisExecutionRequest=" + String.valueOf(this.canaryAnalysisExecutionRequest) + ", canaryConfig=" + String.valueOf(this.canaryConfig) + ", canaryConfigId=" + this.canaryConfigId + ", buildTimeMillis=" + this.buildTimeMillis + ", buildTimeIso=" + this.buildTimeIso + ", startTimeMillis=" + this.startTimeMillis + ", startTimeIso=" + this.startTimeIso + ", endTimeMillis=" + this.endTimeMillis + ", endTimeIso=" + this.endTimeIso + ", storageAccountName=" + this.storageAccountName + ", metricsAccountName=" + this.metricsAccountName + ")";
        }
    }
}

