/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.domain;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotNull;

@Schema(description="Metadata around an Orca StageExecution of the canary analysis pipeline execution")
public class StageMetadata {
    @NotNull
    @Schema(description="The StageExecution type")
    String type;
    @NotNull
    @Schema(description="The StageExecution name")
    String name;
    @NotNull
    @Schema(description="The Orca execution status of the stage")
    ExecutionStatus status;
    @Schema(description="The execution id if the StageExecution is a runCanary stage")
    String executionId;

    public static StageMetadataBuilder builder() {
        return new StageMetadataBuilder();
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public ExecutionStatus getStatus() {
        return this.status;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public StageMetadata setType(String type) {
        this.type = type;
        return this;
    }

    public StageMetadata setName(String name) {
        this.name = name;
        return this;
    }

    public StageMetadata setStatus(ExecutionStatus status) {
        this.status = status;
        return this;
    }

    public StageMetadata setExecutionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StageMetadata)) {
            return false;
        }
        StageMetadata other = (StageMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ExecutionStatus this$status = this.getStatus();
        ExecutionStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        return !(this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StageMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ExecutionStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        return result;
    }

    public StageMetadata() {
    }

    public StageMetadata(String type, String name, ExecutionStatus status, String executionId) {
        this.type = type;
        this.name = name;
        this.status = status;
        this.executionId = executionId;
    }

    public String toString() {
        return "StageMetadata(type=" + this.getType() + ", name=" + this.getName() + ", status=" + String.valueOf(this.getStatus()) + ", executionId=" + this.getExecutionId() + ")";
    }

    public static class StageMetadataBuilder {
        private String type;
        private String name;
        private ExecutionStatus status;
        private String executionId;

        StageMetadataBuilder() {
        }

        public StageMetadataBuilder type(String type) {
            this.type = type;
            return this;
        }

        public StageMetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StageMetadataBuilder status(ExecutionStatus status) {
            this.status = status;
            return this;
        }

        public StageMetadataBuilder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public StageMetadata build() {
            return new StageMetadata(this.type, this.name, this.status, this.executionId);
        }

        public String toString() {
            return "StageMetadata.StageMetadataBuilder(type=" + this.type + ", name=" + this.name + ", status=" + String.valueOf(this.status) + ", executionId=" + this.executionId + ")";
        }
    }
}

