/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.orca.task;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.kayenta.canary.CanaryExecutionStatusResponse;
import com.netflix.kayenta.standalonecanaryanalysis.CanaryAnalysisConfig;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionRequest;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionResult;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryExecutionResult;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GenerateCanaryAnalysisResultTask
implements Task {
    private static final Logger log = LoggerFactory.getLogger(GenerateCanaryAnalysisResultTask.class);
    public static final String CANARY_ANALYSIS_EXECUTION_RESULT = "canaryAnalysisExecutionResult";
    private final ObjectMapper kayentaObjectMapper;

    @Autowired
    public GenerateCanaryAnalysisResultTask(ObjectMapper kayentaObjectMapper) {
        this.kayentaObjectMapper = kayentaObjectMapper;
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        CanaryAnalysisConfig canaryAnalysisConfig = (CanaryAnalysisConfig)this.kayentaObjectMapper.convertValue(stage.getContext().get("canaryAnalysisExecutionRequest"), CanaryAnalysisConfig.class);
        CanaryAnalysisExecutionRequest canaryAnalysisExecutionRequest = canaryAnalysisConfig.getExecutionRequest();
        List<StageExecution> runCanaryStages = this.getRunCanaryStages(stage);
        LinkedList canaryScores = runCanaryStages.stream().map(scoreStage -> (Double)this.kayentaObjectMapper.convertValue((Object)scoreStage.getContext().getOrDefault("canaryScore", 0.0), Double.class)).collect(Collectors.toCollection(LinkedList::new));
        AggregatedJudgement aggregatedJudgement = null;
        if (canaryScores.size() > 0) {
            Double finalCanaryScore = (Double)canaryScores.getLast();
            Double marginalThreshold = canaryAnalysisExecutionRequest.getThresholds().getMarginal();
            Double passThreshold = canaryAnalysisExecutionRequest.getThresholds().getPass();
            aggregatedJudgement = this.getAggregatedJudgment(finalCanaryScore, marginalThreshold, passThreshold);
        } else {
            aggregatedJudgement = new AggregatedJudgement(false, "There were no successful canary judgements to aggregate");
        }
        CanaryAnalysisExecutionResult result = CanaryAnalysisExecutionResult.builder().didPassThresholds(aggregatedJudgement.didPassThresholds).canaryScoreMessage(aggregatedJudgement.getMsg()).canaryScores(canaryScores).hasWarnings(runCanaryStages.stream().map(runStage -> (LinkedList)this.kayentaObjectMapper.convertValue(runStage.getContext().getOrDefault("warnings", new LinkedList()), (TypeReference)new TypeReference<LinkedList<String>>(){})).anyMatch(warnings -> warnings.size() > 0)).canaryExecutionResults(runCanaryStages.stream().map(runStage -> {
            Object data = Optional.ofNullable(runStage.getContext().getOrDefault("canaryExecutionStatusResponse", null)).orElseThrow(() -> new IllegalStateException("Expected completed runCanaryStage to have canaryExecutionStatusResponse in context"));
            CanaryExecutionStatusResponse canaryExecutionStatusResponse = (CanaryExecutionStatusResponse)this.kayentaObjectMapper.convertValue(data, CanaryExecutionStatusResponse.class);
            return CanaryExecutionResult.builder().executionId(canaryExecutionStatusResponse.getPipelineId()).executionStatus(ExecutionStatus.valueOf((String)canaryExecutionStatusResponse.getStatus().toUpperCase())).exception(runStage.getContext().getOrDefault("exception", null)).warnings((List)this.kayentaObjectMapper.convertValue(runStage.getContext().getOrDefault("warnings", new LinkedList()), (TypeReference)new TypeReference<LinkedList<String>>(){})).result(canaryExecutionStatusResponse.getResult()).metricSetPairListId(canaryExecutionStatusResponse.getMetricSetPairListId()).judgementStartTimeIso(Optional.ofNullable(runStage.getContext().getOrDefault("judgementStartTimeIso", null)).orElseThrow(() -> new IllegalStateException("Expected completed runCanaryStage to have judgementStartTimeIso in context"))).judgementStartTimeMillis(Optional.ofNullable(runStage.getContext().getOrDefault("judgementStartTimeMillis", null)).orElseThrow(() -> new IllegalStateException("Expected completed runCanaryStage to have judgementStartTimeIso in context"))).judgementEndTimeIso(Optional.ofNullable(runStage.getContext().getOrDefault("judgementEndTimeIso", null)).orElseThrow(() -> new IllegalStateException("Expected completed runCanaryStage to have judgementStartTimeIso in context"))).judgementEndTimeMillis(Optional.ofNullable(runStage.getContext().getOrDefault("judgementEndTimeMillis", null)).orElseThrow(() -> new IllegalStateException("Expected completed runCanaryStage to have judgementStartTimeIso in context"))).buildTimeMillis(canaryExecutionStatusResponse.getBuildTimeMillis()).buildTimeIso(canaryExecutionStatusResponse.getBuildTimeIso()).startTimeMillis(canaryExecutionStatusResponse.getStartTimeMillis()).startTimeIso(canaryExecutionStatusResponse.getStartTimeIso()).endTimeMillis(canaryExecutionStatusResponse.getEndTimeMillis()).endTimeIso(canaryExecutionStatusResponse.getEndTimeIso()).storageAccountName(canaryExecutionStatusResponse.getStorageAccountName()).configurationAccountName(canaryExecutionStatusResponse.getConfigurationAccountName()).build();
        }).collect(Collectors.toList())).build();
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).output(CANARY_ANALYSIS_EXECUTION_RESULT, (Object)result).build();
    }

    @NotNull
    protected List<StageExecution> getRunCanaryStages(@Nonnull StageExecution stage) {
        return stage.getExecution().getStages().stream().filter(s -> s.getType().equals("runCanary")).sorted(Comparator.comparing(s -> Integer.valueOf(StringUtils.substringAfterLast((String)s.getName(), (String)"#")))).collect(Collectors.toList());
    }

    protected AggregatedJudgement getAggregatedJudgment(Double finalCanaryScore, Double marginalThreshold, Double passThreshold) {
        String msg;
        boolean didPassThresholds;
        if (marginalThreshold == null && passThreshold == null) {
            didPassThresholds = true;
            msg = "No score thresholds were specified.";
        } else if (marginalThreshold != null && finalCanaryScore <= marginalThreshold) {
            didPassThresholds = false;
            msg = String.format("Final canary score %s is not above the marginal score threshold.", finalCanaryScore);
        } else if (passThreshold == null) {
            didPassThresholds = true;
            msg = "No pass score threshold was specified.";
        } else if (finalCanaryScore < passThreshold) {
            didPassThresholds = false;
            msg = String.format("Final canary score %s is below the pass score threshold.", finalCanaryScore);
        } else {
            didPassThresholds = true;
            msg = String.format("Final canary score %s met or exceeded the pass score threshold.", finalCanaryScore);
        }
        return new AggregatedJudgement(didPassThresholds, msg);
    }

    protected class AggregatedJudgement {
        private boolean didPassThresholds;
        private String msg;

        public boolean isDidPassThresholds() {
            return this.didPassThresholds;
        }

        public String getMsg() {
            return this.msg;
        }

        public AggregatedJudgement setDidPassThresholds(boolean didPassThresholds) {
            this.didPassThresholds = didPassThresholds;
            return this;
        }

        public AggregatedJudgement setMsg(String msg) {
            this.msg = msg;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AggregatedJudgement)) {
                return false;
            }
            AggregatedJudgement other = (AggregatedJudgement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDidPassThresholds() != other.isDidPassThresholds()) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AggregatedJudgement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDidPassThresholds() ? 79 : 97);
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            return result;
        }

        public String toString() {
            return "GenerateCanaryAnalysisResultTask.AggregatedJudgement(didPassThresholds=" + this.isDidPassThresholds() + ", msg=" + this.getMsg() + ")";
        }

        public AggregatedJudgement(boolean didPassThresholds, String msg) {
            this.didPassThresholds = didPassThresholds;
            this.msg = msg;
        }
    }
}

