/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.kayenta.canary.CanaryClassifierThresholdsConfig;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionRequestScope;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;

@Schema(description="The canary analysis configuration request object for initiating a canary analysis execution.")
public class CanaryAnalysisExecutionRequest {
    @NotNull
    @Schema(description="This is a list of Canary Analysis Execution Request scopes. This directs the Canary Analysis Execution where to find the experiment and control metrics in the metrics source. The list must have at least one value.")
    private List<CanaryAnalysisExecutionRequestScope> scopes;
    @NotNull
    @Schema(description="The thresholds that will be used for the canary judgements. When multiple judgements are occurring during the lifetime of this execution, the last judgement must have a score that meets or exceeds the pass threshold, all previous judgement scores must meet or exceed the marginal score.")
    private CanaryClassifierThresholdsConfig thresholds;
    @Schema(description="This is the amount of time in minutes the analysis phase of the canary analysis execution will last. Either this value or endTimeIso (in scopes) must be set. ")
    private Long lifetimeDurationMins;
    @NotNull
    @Schema(description="This is how long the canary analysis execution will wait before beginning the analysis phase. This can be useful in a continuous integration situation where the canary analysis execution is triggered asynchronously and metrics are ready for consumption after a time period.")
    private Long beginAfterMins;
    @NotNull
    @Schema(description="If this optional value is supplied, then the canary analysis execution will perform judgements on a sliding time window. The judgements will be from endTime - lookbackMins to startTime + (judgementNumber * interval). If lookbackMins is not exactly equal to interval, then the metrics analyzed will be overlapping or discontinuous.\nIf this field is omitted, the judgements will be performed on a growing time window, from startTime + to startTime + (judgementNumber * interval).\n")
    private Long lookbackMins;
    @Schema(description="The value of analysisIntervalMins is used to calculate how many judgements will occur over the lifetime of the canary analysis execution.\nIf this field is omitted then it will default to lifetime.\nIf this field is set to a value greater than lifetime, it will be reset to lifetime.")
    private Long analysisIntervalMins;
    @Schema(description="A map of customizable data that among other things can be used in org-specific external modules such as event listeners to handle notifications such as Slack, email, async http callbacks, etc.\nThe contents of this field don't have an effect on the actual canary analysis execution.")
    protected Map<String, Object> siteLocal;

    @JsonIgnore
    public Duration getBeginCanaryAnalysisAfterAsDuration() {
        return Duration.ofMinutes(this.beginAfterMins);
    }

    @JsonIgnore
    public Duration getLifetimeDuration() {
        if (this.lifetimeDurationMins != null) {
            return Duration.ofMinutes(this.lifetimeDurationMins);
        }
        return null;
    }

    @JsonIgnore
    public Instant getBeginCanaryAnalysisAfterAsInstant() {
        return Instant.ofEpochMilli(this.getBeginCanaryAnalysisAfterAsDuration().toMillis());
    }

    @JsonIgnore
    public Instant getStartTime() {
        return this.scopes.get(0).getStartTimeAsInstant();
    }

    @JsonIgnore
    public Instant getEndTime() {
        return this.scopes.get(0).getEndTimeAsInstant();
    }

    @JsonIgnore
    public Duration getStep() {
        return Duration.ofSeconds(this.scopes.get(0).getStep());
    }

    @JsonIgnore
    public Duration getLookBackAsDuration() {
        return Duration.ofMinutes(this.lookbackMins);
    }

    @JsonIgnore
    public Instant getLookBackAsInstant() {
        return Instant.ofEpochMilli(this.getLookBackAsDuration().toMillis());
    }

    private static Long $default$beginAfterMins() {
        return 0L;
    }

    private static Long $default$lookbackMins() {
        return 0L;
    }

    public static CanaryAnalysisExecutionRequestBuilder builder() {
        return new CanaryAnalysisExecutionRequestBuilder();
    }

    public List<CanaryAnalysisExecutionRequestScope> getScopes() {
        return this.scopes;
    }

    public CanaryClassifierThresholdsConfig getThresholds() {
        return this.thresholds;
    }

    public Long getLifetimeDurationMins() {
        return this.lifetimeDurationMins;
    }

    public Long getBeginAfterMins() {
        return this.beginAfterMins;
    }

    public Long getLookbackMins() {
        return this.lookbackMins;
    }

    public Long getAnalysisIntervalMins() {
        return this.analysisIntervalMins;
    }

    public Map<String, Object> getSiteLocal() {
        return this.siteLocal;
    }

    public CanaryAnalysisExecutionRequest setScopes(List<CanaryAnalysisExecutionRequestScope> scopes) {
        this.scopes = scopes;
        return this;
    }

    public CanaryAnalysisExecutionRequest setThresholds(CanaryClassifierThresholdsConfig thresholds) {
        this.thresholds = thresholds;
        return this;
    }

    public CanaryAnalysisExecutionRequest setLifetimeDurationMins(Long lifetimeDurationMins) {
        this.lifetimeDurationMins = lifetimeDurationMins;
        return this;
    }

    public CanaryAnalysisExecutionRequest setBeginAfterMins(Long beginAfterMins) {
        this.beginAfterMins = beginAfterMins;
        return this;
    }

    public CanaryAnalysisExecutionRequest setLookbackMins(Long lookbackMins) {
        this.lookbackMins = lookbackMins;
        return this;
    }

    public CanaryAnalysisExecutionRequest setAnalysisIntervalMins(Long analysisIntervalMins) {
        this.analysisIntervalMins = analysisIntervalMins;
        return this;
    }

    public CanaryAnalysisExecutionRequest setSiteLocal(Map<String, Object> siteLocal) {
        this.siteLocal = siteLocal;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CanaryAnalysisExecutionRequest)) {
            return false;
        }
        CanaryAnalysisExecutionRequest other = (CanaryAnalysisExecutionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$lifetimeDurationMins = this.getLifetimeDurationMins();
        Long other$lifetimeDurationMins = other.getLifetimeDurationMins();
        if (this$lifetimeDurationMins == null ? other$lifetimeDurationMins != null : !((Object)this$lifetimeDurationMins).equals(other$lifetimeDurationMins)) {
            return false;
        }
        Long this$beginAfterMins = this.getBeginAfterMins();
        Long other$beginAfterMins = other.getBeginAfterMins();
        if (this$beginAfterMins == null ? other$beginAfterMins != null : !((Object)this$beginAfterMins).equals(other$beginAfterMins)) {
            return false;
        }
        Long this$lookbackMins = this.getLookbackMins();
        Long other$lookbackMins = other.getLookbackMins();
        if (this$lookbackMins == null ? other$lookbackMins != null : !((Object)this$lookbackMins).equals(other$lookbackMins)) {
            return false;
        }
        Long this$analysisIntervalMins = this.getAnalysisIntervalMins();
        Long other$analysisIntervalMins = other.getAnalysisIntervalMins();
        if (this$analysisIntervalMins == null ? other$analysisIntervalMins != null : !((Object)this$analysisIntervalMins).equals(other$analysisIntervalMins)) {
            return false;
        }
        List<CanaryAnalysisExecutionRequestScope> this$scopes = this.getScopes();
        List<CanaryAnalysisExecutionRequestScope> other$scopes = other.getScopes();
        if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
            return false;
        }
        CanaryClassifierThresholdsConfig this$thresholds = this.getThresholds();
        CanaryClassifierThresholdsConfig other$thresholds = other.getThresholds();
        if (this$thresholds == null ? other$thresholds != null : !this$thresholds.equals(other$thresholds)) {
            return false;
        }
        Map<String, Object> this$siteLocal = this.getSiteLocal();
        Map<String, Object> other$siteLocal = other.getSiteLocal();
        return !(this$siteLocal == null ? other$siteLocal != null : !((Object)this$siteLocal).equals(other$siteLocal));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CanaryAnalysisExecutionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $lifetimeDurationMins = this.getLifetimeDurationMins();
        result = result * 59 + ($lifetimeDurationMins == null ? 43 : ((Object)$lifetimeDurationMins).hashCode());
        Long $beginAfterMins = this.getBeginAfterMins();
        result = result * 59 + ($beginAfterMins == null ? 43 : ((Object)$beginAfterMins).hashCode());
        Long $lookbackMins = this.getLookbackMins();
        result = result * 59 + ($lookbackMins == null ? 43 : ((Object)$lookbackMins).hashCode());
        Long $analysisIntervalMins = this.getAnalysisIntervalMins();
        result = result * 59 + ($analysisIntervalMins == null ? 43 : ((Object)$analysisIntervalMins).hashCode());
        List<CanaryAnalysisExecutionRequestScope> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        CanaryClassifierThresholdsConfig $thresholds = this.getThresholds();
        result = result * 59 + ($thresholds == null ? 43 : $thresholds.hashCode());
        Map<String, Object> $siteLocal = this.getSiteLocal();
        result = result * 59 + ($siteLocal == null ? 43 : ((Object)$siteLocal).hashCode());
        return result;
    }

    public String toString() {
        return "CanaryAnalysisExecutionRequest(scopes=" + String.valueOf(this.getScopes()) + ", thresholds=" + String.valueOf(this.getThresholds()) + ", lifetimeDurationMins=" + this.getLifetimeDurationMins() + ", beginAfterMins=" + this.getBeginAfterMins() + ", lookbackMins=" + this.getLookbackMins() + ", analysisIntervalMins=" + this.getAnalysisIntervalMins() + ", siteLocal=" + String.valueOf(this.getSiteLocal()) + ")";
    }

    public CanaryAnalysisExecutionRequest(List<CanaryAnalysisExecutionRequestScope> scopes, CanaryClassifierThresholdsConfig thresholds, Long lifetimeDurationMins, Long beginAfterMins, Long lookbackMins, Long analysisIntervalMins, Map<String, Object> siteLocal) {
        this.scopes = scopes;
        this.thresholds = thresholds;
        this.lifetimeDurationMins = lifetimeDurationMins;
        this.beginAfterMins = beginAfterMins;
        this.lookbackMins = lookbackMins;
        this.analysisIntervalMins = analysisIntervalMins;
        this.siteLocal = siteLocal;
    }

    public CanaryAnalysisExecutionRequest() {
        this.beginAfterMins = CanaryAnalysisExecutionRequest.$default$beginAfterMins();
        this.lookbackMins = CanaryAnalysisExecutionRequest.$default$lookbackMins();
    }

    public static class CanaryAnalysisExecutionRequestBuilder {
        private List<CanaryAnalysisExecutionRequestScope> scopes;
        private CanaryClassifierThresholdsConfig thresholds;
        private Long lifetimeDurationMins;
        private boolean beginAfterMins$set;
        private Long beginAfterMins$value;
        private boolean lookbackMins$set;
        private Long lookbackMins$value;
        private Long analysisIntervalMins;
        private Map<String, Object> siteLocal;

        CanaryAnalysisExecutionRequestBuilder() {
        }

        public CanaryAnalysisExecutionRequestBuilder scopes(List<CanaryAnalysisExecutionRequestScope> scopes) {
            this.scopes = scopes;
            return this;
        }

        public CanaryAnalysisExecutionRequestBuilder thresholds(CanaryClassifierThresholdsConfig thresholds) {
            this.thresholds = thresholds;
            return this;
        }

        public CanaryAnalysisExecutionRequestBuilder lifetimeDurationMins(Long lifetimeDurationMins) {
            this.lifetimeDurationMins = lifetimeDurationMins;
            return this;
        }

        public CanaryAnalysisExecutionRequestBuilder beginAfterMins(Long beginAfterMins) {
            this.beginAfterMins$value = beginAfterMins;
            this.beginAfterMins$set = true;
            return this;
        }

        public CanaryAnalysisExecutionRequestBuilder lookbackMins(Long lookbackMins) {
            this.lookbackMins$value = lookbackMins;
            this.lookbackMins$set = true;
            return this;
        }

        public CanaryAnalysisExecutionRequestBuilder analysisIntervalMins(Long analysisIntervalMins) {
            this.analysisIntervalMins = analysisIntervalMins;
            return this;
        }

        public CanaryAnalysisExecutionRequestBuilder siteLocal(Map<String, Object> siteLocal) {
            this.siteLocal = siteLocal;
            return this;
        }

        public CanaryAnalysisExecutionRequest build() {
            Long beginAfterMins$value = this.beginAfterMins$value;
            if (!this.beginAfterMins$set) {
                beginAfterMins$value = CanaryAnalysisExecutionRequest.$default$beginAfterMins();
            }
            Long lookbackMins$value = this.lookbackMins$value;
            if (!this.lookbackMins$set) {
                lookbackMins$value = CanaryAnalysisExecutionRequest.$default$lookbackMins();
            }
            return new CanaryAnalysisExecutionRequest(this.scopes, this.thresholds, this.lifetimeDurationMins, beginAfterMins$value, lookbackMins$value, this.analysisIntervalMins, this.siteLocal);
        }

        public String toString() {
            return "CanaryAnalysisExecutionRequest.CanaryAnalysisExecutionRequestBuilder(scopes=" + String.valueOf(this.scopes) + ", thresholds=" + String.valueOf(this.thresholds) + ", lifetimeDurationMins=" + this.lifetimeDurationMins + ", beginAfterMins$value=" + this.beginAfterMins$value + ", lookbackMins$value=" + this.lookbackMins$value + ", analysisIntervalMins=" + this.analysisIntervalMins + ", siteLocal=" + String.valueOf(this.siteLocal) + ")";
        }
    }
}

