/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import com.netflix.kayenta.standalonecanaryanalysis.CanaryAnalysisConfig;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionResponse;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionResult;
import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryAnalysisExecutionStatusResponse;
import com.netflix.kayenta.standalonecanaryanalysis.domain.StageMetadata;
import com.netflix.kayenta.standalonecanaryanalysis.orca.MonitorKayentaCanaryContext;
import com.netflix.kayenta.standalonecanaryanalysis.storage.StandaloneCanaryAnalysisObjectType;
import com.netflix.kayenta.storage.StorageService;
import com.netflix.kayenta.storage.StorageServiceRepository;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.pipeline.ExecutionLauncher;
import com.netflix.spinnaker.orca.pipeline.model.PipelineBuilder;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionNotFoundException;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class CanaryAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(CanaryAnalysisService.class);
    public static final String CANARY_ANALYSIS_CONFIG_CONTEXT_KEY = "canaryAnalysisExecutionRequest";
    public static final String CANARY_ANALYSIS_PIPELINE_NAME = "Standalone Canary Analysis Pipeline";
    private final ExecutionLauncher executionLauncher;
    private final ExecutionRepository executionRepository;
    private final StorageServiceRepository storageServiceRepository;
    private final ObjectMapper kayentaObjectMapper;
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final boolean includeAuthentication;

    @Autowired
    public CanaryAnalysisService(ExecutionLauncher executionLauncher, ExecutionRepository executionRepository, StorageServiceRepository storageServiceRepository, ObjectMapper kayentaObjectMapper, AccountCredentialsRepository accountCredentialsRepository, @Value(value="${kayenta.include-spring-security-authentication-in-pipeline-context:false}") boolean includeAuthentication) {
        this.executionLauncher = executionLauncher;
        this.executionRepository = executionRepository;
        this.storageServiceRepository = storageServiceRepository;
        this.kayentaObjectMapper = kayentaObjectMapper;
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.includeAuthentication = includeAuthentication;
    }

    public CanaryAnalysisExecutionResponse initiateCanaryAnalysisExecution(CanaryAnalysisConfig canaryAnalysisConfig) {
        String application = canaryAnalysisConfig.getApplication();
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder().put((Object)CANARY_ANALYSIS_CONFIG_CONTEXT_KEY, (Object)canaryAnalysisConfig);
        if (this.includeAuthentication) {
            Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).ifPresent(authentication -> mapBuilder.put((Object)"springSecurityAuthentication", authentication));
        }
        PipelineBuilder pipelineBuilder = new PipelineBuilder(application).withName(CANARY_ANALYSIS_PIPELINE_NAME).withPipelineConfigId(application + "-canary-analysis-referee-pipeline").withStage("setupAndExecuteCanariesStage", "Sets up and executes the wait, run and monitor canary task chain.", (Map)Maps.newHashMap((Map)mapBuilder.build()));
        PipelineExecution pipeline = pipelineBuilder.withLimitConcurrent(false).build();
        this.executionRepository.store(pipeline);
        try {
            this.executionLauncher.start(pipeline);
        }
        catch (Throwable t) {
            log.error("Failed to start pipeline", t);
            this.handleStartupFailure(pipeline, t);
            throw new RuntimeException("Failed to start the canary analysis pipeline execution");
        }
        return CanaryAnalysisExecutionResponse.builder().canaryAnalysisExecutionId(pipeline.getId()).build();
    }

    public CanaryAnalysisExecutionStatusResponse getCanaryAnalysisExecution(String canaryAnalysisExecutionId, String nullableStorageAccountName) {
        try {
            PipelineExecution execution = this.executionRepository.retrieve(ExecutionType.PIPELINE, canaryAnalysisExecutionId);
            return this.fromExecution(execution);
        }
        catch (ExecutionNotFoundException e) {
            return Optional.ofNullable(nullableStorageAccountName).map(storageAccountName -> {
                String resolvedStorageAccountName = this.accountCredentialsRepository.getRequiredOneBy(storageAccountName, AccountCredentials.Type.OBJECT_STORE).getName();
                StorageService storageService = this.storageServiceRepository.getRequiredOne(resolvedStorageAccountName);
                return (CanaryAnalysisExecutionStatusResponse)storageService.loadObject(resolvedStorageAccountName, StandaloneCanaryAnalysisObjectType.STANDALONE_CANARY_RESULT_ARCHIVE, canaryAnalysisExecutionId);
            }).orElseThrow(() -> e);
        }
    }

    private void handleStartupFailure(PipelineExecution execution, Throwable failure) {
        String canceledBy = "system";
        String reason = "Failed on startup: " + failure.getMessage();
        ExecutionStatus status = ExecutionStatus.TERMINAL;
        log.error("Failed to start {} {}", new Object[]{execution.getType(), execution.getId(), failure});
        this.executionRepository.updateStatus(execution.getType(), execution.getId(), status);
        this.executionRepository.cancel(execution.getType(), execution.getId(), "system", reason);
    }

    protected CanaryAnalysisExecutionStatusResponse fromExecution(PipelineExecution pipeline) {
        Long endTime;
        Long startTime;
        CanaryAnalysisExecutionStatusResponse.CanaryAnalysisExecutionStatusResponseBuilder responseBuilder = CanaryAnalysisExecutionStatusResponse.builder().application(pipeline.getApplication()).pipelineId(pipeline.getId()).stageStatus(pipeline.getStages().stream().map(stage -> new StageMetadata(stage.getType(), stage.getName(), stage.getStatus(), ((MonitorKayentaCanaryContext)stage.mapTo(MonitorKayentaCanaryContext.class)).getCanaryPipelineExecutionId())).collect(Collectors.toList())).complete(pipeline.getStatus().isComplete()).executionStatus(pipeline.getStatus());
        pipeline.getStages().stream().filter(stage -> stage.getType().equals("setupAndExecuteCanariesStage")).findFirst().map(stage -> stage.getContext().get(CANARY_ANALYSIS_CONFIG_CONTEXT_KEY)).ifPresent(data -> {
            CanaryAnalysisConfig canaryAnalysisConfig = (CanaryAnalysisConfig)this.kayentaObjectMapper.convertValue(data, CanaryAnalysisConfig.class);
            responseBuilder.parentPipelineExecutionId(canaryAnalysisConfig.getParentPipelineExecutionId());
            responseBuilder.user(canaryAnalysisConfig.getUser());
            responseBuilder.application(canaryAnalysisConfig.getApplication());
            responseBuilder.canaryConfigId(canaryAnalysisConfig.getCanaryConfigId());
            responseBuilder.canaryAnalysisExecutionRequest(canaryAnalysisConfig.getExecutionRequest());
            responseBuilder.canaryConfig(canaryAnalysisConfig.getCanaryConfig());
            responseBuilder.storageAccountName(canaryAnalysisConfig.getStorageAccountName());
            responseBuilder.metricsAccountName(canaryAnalysisConfig.getMetricsAccountName());
        });
        pipeline.getStages().stream().filter(stage -> stage.getType().equals("generateCanaryAnalysisResultStage")).findFirst().map(generateCanaryAnalysisResultStage -> generateCanaryAnalysisResultStage.getOutputs().get("canaryAnalysisExecutionResult")).ifPresent(data -> responseBuilder.canaryAnalysisExecutionResult((CanaryAnalysisExecutionResult)this.kayentaObjectMapper.convertValue(data, CanaryAnalysisExecutionResult.class)));
        pipeline.getStages().stream().filter(stage -> stage.getContext().containsKey("exception")).findFirst().ifPresent(stage -> responseBuilder.exception(stage.getContext().get("exception")));
        Long buildTime = pipeline.getBuildTime();
        if (buildTime != null) {
            responseBuilder.buildTimeMillis(buildTime).buildTimeIso(String.valueOf(Instant.ofEpochMilli(buildTime)));
        }
        if ((startTime = pipeline.getStartTime()) != null) {
            responseBuilder.startTimeMillis(startTime).startTimeIso(String.valueOf(Instant.ofEpochMilli(startTime)));
        }
        if ((endTime = pipeline.getEndTime()) != null) {
            responseBuilder.endTimeMillis(endTime).endTimeIso(String.valueOf(Instant.ofEpochMilli(endTime)));
        }
        return responseBuilder.build();
    }
}

