/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.domain;

import com.netflix.kayenta.standalonecanaryanalysis.domain.CanaryExecutionResult;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;

@Schema(description="The canary analysis execution results.")
public class CanaryAnalysisExecutionResult {
    @Schema(description="This boolean represents whether the canary passed the defined thresholds.")
    protected boolean didPassThresholds;
    @Schema(description="This boolean is set to true if any of the judgements had warnings.")
    protected boolean hasWarnings;
    @Schema(description="This string describes the aggregated judgement results.")
    protected String canaryScoreMessage;
    @Schema(description="This is an ordered list of the individual judgement scores. The last score is used for determining the final result.")
    @NonNull
    protected List<Double> canaryScores;
    @Schema(description="This is a list of canary execution summaries.")
    @NonNull
    protected List<CanaryExecutionResult> canaryExecutionResults;
    @Schema(description="buildTimeIso is an ISO 8061 string and refers to the time the pipeline was first created.")
    protected String buildTimeIso;
    @Schema(description="startTimeIso is an ISO 8061 string and refers to the time the pipeline started running.")
    protected String startTimeIso;
    @Schema(description="endTimeIso is an ISO 8061 string and refers to the time the pipeline ended, either successfully or unsuccessfully.")
    protected String endTimeIso;

    private static List<Double> $default$canaryScores() {
        return new LinkedList<Double>();
    }

    private static List<CanaryExecutionResult> $default$canaryExecutionResults() {
        return new LinkedList<CanaryExecutionResult>();
    }

    public static CanaryAnalysisExecutionResultBuilder builder() {
        return new CanaryAnalysisExecutionResultBuilder();
    }

    public boolean isDidPassThresholds() {
        return this.didPassThresholds;
    }

    public boolean isHasWarnings() {
        return this.hasWarnings;
    }

    public String getCanaryScoreMessage() {
        return this.canaryScoreMessage;
    }

    @NonNull
    public List<Double> getCanaryScores() {
        return this.canaryScores;
    }

    @NonNull
    public List<CanaryExecutionResult> getCanaryExecutionResults() {
        return this.canaryExecutionResults;
    }

    public String getBuildTimeIso() {
        return this.buildTimeIso;
    }

    public String getStartTimeIso() {
        return this.startTimeIso;
    }

    public String getEndTimeIso() {
        return this.endTimeIso;
    }

    public CanaryAnalysisExecutionResult setDidPassThresholds(boolean didPassThresholds) {
        this.didPassThresholds = didPassThresholds;
        return this;
    }

    public CanaryAnalysisExecutionResult setHasWarnings(boolean hasWarnings) {
        this.hasWarnings = hasWarnings;
        return this;
    }

    public CanaryAnalysisExecutionResult setCanaryScoreMessage(String canaryScoreMessage) {
        this.canaryScoreMessage = canaryScoreMessage;
        return this;
    }

    public CanaryAnalysisExecutionResult setCanaryScores(@NonNull List<Double> canaryScores) {
        if (canaryScores == null) {
            throw new IllegalArgumentException("canaryScores is marked non-null but is null");
        }
        this.canaryScores = canaryScores;
        return this;
    }

    public CanaryAnalysisExecutionResult setCanaryExecutionResults(@NonNull List<CanaryExecutionResult> canaryExecutionResults) {
        if (canaryExecutionResults == null) {
            throw new IllegalArgumentException("canaryExecutionResults is marked non-null but is null");
        }
        this.canaryExecutionResults = canaryExecutionResults;
        return this;
    }

    public CanaryAnalysisExecutionResult setBuildTimeIso(String buildTimeIso) {
        this.buildTimeIso = buildTimeIso;
        return this;
    }

    public CanaryAnalysisExecutionResult setStartTimeIso(String startTimeIso) {
        this.startTimeIso = startTimeIso;
        return this;
    }

    public CanaryAnalysisExecutionResult setEndTimeIso(String endTimeIso) {
        this.endTimeIso = endTimeIso;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CanaryAnalysisExecutionResult)) {
            return false;
        }
        CanaryAnalysisExecutionResult other = (CanaryAnalysisExecutionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDidPassThresholds() != other.isDidPassThresholds()) {
            return false;
        }
        if (this.isHasWarnings() != other.isHasWarnings()) {
            return false;
        }
        String this$canaryScoreMessage = this.getCanaryScoreMessage();
        String other$canaryScoreMessage = other.getCanaryScoreMessage();
        if (this$canaryScoreMessage == null ? other$canaryScoreMessage != null : !this$canaryScoreMessage.equals(other$canaryScoreMessage)) {
            return false;
        }
        List<Double> this$canaryScores = this.getCanaryScores();
        List<Double> other$canaryScores = other.getCanaryScores();
        if (this$canaryScores == null ? other$canaryScores != null : !((Object)this$canaryScores).equals(other$canaryScores)) {
            return false;
        }
        List<CanaryExecutionResult> this$canaryExecutionResults = this.getCanaryExecutionResults();
        List<CanaryExecutionResult> other$canaryExecutionResults = other.getCanaryExecutionResults();
        if (this$canaryExecutionResults == null ? other$canaryExecutionResults != null : !((Object)this$canaryExecutionResults).equals(other$canaryExecutionResults)) {
            return false;
        }
        String this$buildTimeIso = this.getBuildTimeIso();
        String other$buildTimeIso = other.getBuildTimeIso();
        if (this$buildTimeIso == null ? other$buildTimeIso != null : !this$buildTimeIso.equals(other$buildTimeIso)) {
            return false;
        }
        String this$startTimeIso = this.getStartTimeIso();
        String other$startTimeIso = other.getStartTimeIso();
        if (this$startTimeIso == null ? other$startTimeIso != null : !this$startTimeIso.equals(other$startTimeIso)) {
            return false;
        }
        String this$endTimeIso = this.getEndTimeIso();
        String other$endTimeIso = other.getEndTimeIso();
        return !(this$endTimeIso == null ? other$endTimeIso != null : !this$endTimeIso.equals(other$endTimeIso));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CanaryAnalysisExecutionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDidPassThresholds() ? 79 : 97);
        result = result * 59 + (this.isHasWarnings() ? 79 : 97);
        String $canaryScoreMessage = this.getCanaryScoreMessage();
        result = result * 59 + ($canaryScoreMessage == null ? 43 : $canaryScoreMessage.hashCode());
        List<Double> $canaryScores = this.getCanaryScores();
        result = result * 59 + ($canaryScores == null ? 43 : ((Object)$canaryScores).hashCode());
        List<CanaryExecutionResult> $canaryExecutionResults = this.getCanaryExecutionResults();
        result = result * 59 + ($canaryExecutionResults == null ? 43 : ((Object)$canaryExecutionResults).hashCode());
        String $buildTimeIso = this.getBuildTimeIso();
        result = result * 59 + ($buildTimeIso == null ? 43 : $buildTimeIso.hashCode());
        String $startTimeIso = this.getStartTimeIso();
        result = result * 59 + ($startTimeIso == null ? 43 : $startTimeIso.hashCode());
        String $endTimeIso = this.getEndTimeIso();
        result = result * 59 + ($endTimeIso == null ? 43 : $endTimeIso.hashCode());
        return result;
    }

    public String toString() {
        return "CanaryAnalysisExecutionResult(didPassThresholds=" + this.isDidPassThresholds() + ", hasWarnings=" + this.isHasWarnings() + ", canaryScoreMessage=" + this.getCanaryScoreMessage() + ", canaryScores=" + String.valueOf(this.getCanaryScores()) + ", canaryExecutionResults=" + String.valueOf(this.getCanaryExecutionResults()) + ", buildTimeIso=" + this.getBuildTimeIso() + ", startTimeIso=" + this.getStartTimeIso() + ", endTimeIso=" + this.getEndTimeIso() + ")";
    }

    public CanaryAnalysisExecutionResult() {
        this.canaryScores = CanaryAnalysisExecutionResult.$default$canaryScores();
        this.canaryExecutionResults = CanaryAnalysisExecutionResult.$default$canaryExecutionResults();
    }

    public CanaryAnalysisExecutionResult(boolean didPassThresholds, boolean hasWarnings, String canaryScoreMessage, @NonNull List<Double> canaryScores, @NonNull List<CanaryExecutionResult> canaryExecutionResults, String buildTimeIso, String startTimeIso, String endTimeIso) {
        if (canaryScores == null) {
            throw new IllegalArgumentException("canaryScores is marked non-null but is null");
        }
        if (canaryExecutionResults == null) {
            throw new IllegalArgumentException("canaryExecutionResults is marked non-null but is null");
        }
        this.didPassThresholds = didPassThresholds;
        this.hasWarnings = hasWarnings;
        this.canaryScoreMessage = canaryScoreMessage;
        this.canaryScores = canaryScores;
        this.canaryExecutionResults = canaryExecutionResults;
        this.buildTimeIso = buildTimeIso;
        this.startTimeIso = startTimeIso;
        this.endTimeIso = endTimeIso;
    }

    public static class CanaryAnalysisExecutionResultBuilder {
        private boolean didPassThresholds;
        private boolean hasWarnings;
        private String canaryScoreMessage;
        private boolean canaryScores$set;
        private List<Double> canaryScores$value;
        private boolean canaryExecutionResults$set;
        private List<CanaryExecutionResult> canaryExecutionResults$value;
        private String buildTimeIso;
        private String startTimeIso;
        private String endTimeIso;

        CanaryAnalysisExecutionResultBuilder() {
        }

        public CanaryAnalysisExecutionResultBuilder didPassThresholds(boolean didPassThresholds) {
            this.didPassThresholds = didPassThresholds;
            return this;
        }

        public CanaryAnalysisExecutionResultBuilder hasWarnings(boolean hasWarnings) {
            this.hasWarnings = hasWarnings;
            return this;
        }

        public CanaryAnalysisExecutionResultBuilder canaryScoreMessage(String canaryScoreMessage) {
            this.canaryScoreMessage = canaryScoreMessage;
            return this;
        }

        public CanaryAnalysisExecutionResultBuilder canaryScores(@NonNull List<Double> canaryScores) {
            if (canaryScores == null) {
                throw new IllegalArgumentException("canaryScores is marked non-null but is null");
            }
            this.canaryScores$value = canaryScores;
            this.canaryScores$set = true;
            return this;
        }

        public CanaryAnalysisExecutionResultBuilder canaryExecutionResults(@NonNull List<CanaryExecutionResult> canaryExecutionResults) {
            if (canaryExecutionResults == null) {
                throw new IllegalArgumentException("canaryExecutionResults is marked non-null but is null");
            }
            this.canaryExecutionResults$value = canaryExecutionResults;
            this.canaryExecutionResults$set = true;
            return this;
        }

        public CanaryAnalysisExecutionResultBuilder buildTimeIso(String buildTimeIso) {
            this.buildTimeIso = buildTimeIso;
            return this;
        }

        public CanaryAnalysisExecutionResultBuilder startTimeIso(String startTimeIso) {
            this.startTimeIso = startTimeIso;
            return this;
        }

        public CanaryAnalysisExecutionResultBuilder endTimeIso(String endTimeIso) {
            this.endTimeIso = endTimeIso;
            return this;
        }

        public CanaryAnalysisExecutionResult build() {
            List<Double> canaryScores$value = this.canaryScores$value;
            if (!this.canaryScores$set) {
                canaryScores$value = CanaryAnalysisExecutionResult.$default$canaryScores();
            }
            List<CanaryExecutionResult> canaryExecutionResults$value = this.canaryExecutionResults$value;
            if (!this.canaryExecutionResults$set) {
                canaryExecutionResults$value = CanaryAnalysisExecutionResult.$default$canaryExecutionResults();
            }
            return new CanaryAnalysisExecutionResult(this.didPassThresholds, this.hasWarnings, this.canaryScoreMessage, canaryScores$value, canaryExecutionResults$value, this.buildTimeIso, this.startTimeIso, this.endTimeIso);
        }

        public String toString() {
            return "CanaryAnalysisExecutionResult.CanaryAnalysisExecutionResultBuilder(didPassThresholds=" + this.didPassThresholds + ", hasWarnings=" + this.hasWarnings + ", canaryScoreMessage=" + this.canaryScoreMessage + ", canaryScores$value=" + String.valueOf(this.canaryScores$value) + ", canaryExecutionResults$value=" + String.valueOf(this.canaryExecutionResults$value) + ", buildTimeIso=" + this.buildTimeIso + ", startTimeIso=" + this.startTimeIso + ", endTimeIso=" + this.endTimeIso + ")";
        }
    }
}

