/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.standalonecanaryanalysis.orca;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.netflix.kayenta.canary.CanaryClassifierThresholdsConfig;
import com.netflix.kayenta.canary.CanaryConfig;
import com.netflix.kayenta.canary.CanaryScopePair;
import java.util.Map;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RunCanaryContext {
    private String application;
    private String parentPipelineExecutionId;
    private String canaryConfigId;
    private String user;
    private String metricsAccountName;
    private String storageAccountName;
    private Map<String, Object> siteLocal;
    @NonNull
    private CanaryConfig canaryConfig;
    @NonNull
    private Map<String, CanaryScopePair> scopes;
    @NonNull
    private CanaryClassifierThresholdsConfig scoreThresholds;

    public static RunCanaryContextBuilder builder() {
        return new RunCanaryContextBuilder();
    }

    public String getApplication() {
        return this.application;
    }

    public String getParentPipelineExecutionId() {
        return this.parentPipelineExecutionId;
    }

    public String getCanaryConfigId() {
        return this.canaryConfigId;
    }

    public String getUser() {
        return this.user;
    }

    public String getMetricsAccountName() {
        return this.metricsAccountName;
    }

    public String getStorageAccountName() {
        return this.storageAccountName;
    }

    public Map<String, Object> getSiteLocal() {
        return this.siteLocal;
    }

    @NonNull
    public CanaryConfig getCanaryConfig() {
        return this.canaryConfig;
    }

    @NonNull
    public Map<String, CanaryScopePair> getScopes() {
        return this.scopes;
    }

    @NonNull
    public CanaryClassifierThresholdsConfig getScoreThresholds() {
        return this.scoreThresholds;
    }

    public RunCanaryContext setApplication(String application) {
        this.application = application;
        return this;
    }

    public RunCanaryContext setParentPipelineExecutionId(String parentPipelineExecutionId) {
        this.parentPipelineExecutionId = parentPipelineExecutionId;
        return this;
    }

    public RunCanaryContext setCanaryConfigId(String canaryConfigId) {
        this.canaryConfigId = canaryConfigId;
        return this;
    }

    public RunCanaryContext setUser(String user) {
        this.user = user;
        return this;
    }

    public RunCanaryContext setMetricsAccountName(String metricsAccountName) {
        this.metricsAccountName = metricsAccountName;
        return this;
    }

    public RunCanaryContext setStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
        return this;
    }

    public RunCanaryContext setSiteLocal(Map<String, Object> siteLocal) {
        this.siteLocal = siteLocal;
        return this;
    }

    public RunCanaryContext setCanaryConfig(@NonNull CanaryConfig canaryConfig) {
        if (canaryConfig == null) {
            throw new IllegalArgumentException("canaryConfig is marked non-null but is null");
        }
        this.canaryConfig = canaryConfig;
        return this;
    }

    public RunCanaryContext setScopes(@NonNull Map<String, CanaryScopePair> scopes) {
        if (scopes == null) {
            throw new IllegalArgumentException("scopes is marked non-null but is null");
        }
        this.scopes = scopes;
        return this;
    }

    public RunCanaryContext setScoreThresholds(@NonNull CanaryClassifierThresholdsConfig scoreThresholds) {
        if (scoreThresholds == null) {
            throw new IllegalArgumentException("scoreThresholds is marked non-null but is null");
        }
        this.scoreThresholds = scoreThresholds;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RunCanaryContext)) {
            return false;
        }
        RunCanaryContext other = (RunCanaryContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$parentPipelineExecutionId = this.getParentPipelineExecutionId();
        String other$parentPipelineExecutionId = other.getParentPipelineExecutionId();
        if (this$parentPipelineExecutionId == null ? other$parentPipelineExecutionId != null : !this$parentPipelineExecutionId.equals(other$parentPipelineExecutionId)) {
            return false;
        }
        String this$canaryConfigId = this.getCanaryConfigId();
        String other$canaryConfigId = other.getCanaryConfigId();
        if (this$canaryConfigId == null ? other$canaryConfigId != null : !this$canaryConfigId.equals(other$canaryConfigId)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$metricsAccountName = this.getMetricsAccountName();
        String other$metricsAccountName = other.getMetricsAccountName();
        if (this$metricsAccountName == null ? other$metricsAccountName != null : !this$metricsAccountName.equals(other$metricsAccountName)) {
            return false;
        }
        String this$storageAccountName = this.getStorageAccountName();
        String other$storageAccountName = other.getStorageAccountName();
        if (this$storageAccountName == null ? other$storageAccountName != null : !this$storageAccountName.equals(other$storageAccountName)) {
            return false;
        }
        Map<String, Object> this$siteLocal = this.getSiteLocal();
        Map<String, Object> other$siteLocal = other.getSiteLocal();
        if (this$siteLocal == null ? other$siteLocal != null : !((Object)this$siteLocal).equals(other$siteLocal)) {
            return false;
        }
        CanaryConfig this$canaryConfig = this.getCanaryConfig();
        CanaryConfig other$canaryConfig = other.getCanaryConfig();
        if (this$canaryConfig == null ? other$canaryConfig != null : !this$canaryConfig.equals(other$canaryConfig)) {
            return false;
        }
        Map<String, CanaryScopePair> this$scopes = this.getScopes();
        Map<String, CanaryScopePair> other$scopes = other.getScopes();
        if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
            return false;
        }
        CanaryClassifierThresholdsConfig this$scoreThresholds = this.getScoreThresholds();
        CanaryClassifierThresholdsConfig other$scoreThresholds = other.getScoreThresholds();
        return !(this$scoreThresholds == null ? other$scoreThresholds != null : !this$scoreThresholds.equals(other$scoreThresholds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RunCanaryContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $parentPipelineExecutionId = this.getParentPipelineExecutionId();
        result = result * 59 + ($parentPipelineExecutionId == null ? 43 : $parentPipelineExecutionId.hashCode());
        String $canaryConfigId = this.getCanaryConfigId();
        result = result * 59 + ($canaryConfigId == null ? 43 : $canaryConfigId.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $metricsAccountName = this.getMetricsAccountName();
        result = result * 59 + ($metricsAccountName == null ? 43 : $metricsAccountName.hashCode());
        String $storageAccountName = this.getStorageAccountName();
        result = result * 59 + ($storageAccountName == null ? 43 : $storageAccountName.hashCode());
        Map<String, Object> $siteLocal = this.getSiteLocal();
        result = result * 59 + ($siteLocal == null ? 43 : ((Object)$siteLocal).hashCode());
        CanaryConfig $canaryConfig = this.getCanaryConfig();
        result = result * 59 + ($canaryConfig == null ? 43 : $canaryConfig.hashCode());
        Map<String, CanaryScopePair> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        CanaryClassifierThresholdsConfig $scoreThresholds = this.getScoreThresholds();
        result = result * 59 + ($scoreThresholds == null ? 43 : $scoreThresholds.hashCode());
        return result;
    }

    public String toString() {
        return "RunCanaryContext(application=" + this.getApplication() + ", parentPipelineExecutionId=" + this.getParentPipelineExecutionId() + ", canaryConfigId=" + this.getCanaryConfigId() + ", user=" + this.getUser() + ", metricsAccountName=" + this.getMetricsAccountName() + ", storageAccountName=" + this.getStorageAccountName() + ", siteLocal=" + String.valueOf(this.getSiteLocal()) + ", canaryConfig=" + String.valueOf(this.getCanaryConfig()) + ", scopes=" + String.valueOf(this.getScopes()) + ", scoreThresholds=" + String.valueOf(this.getScoreThresholds()) + ")";
    }

    public RunCanaryContext(String application, String parentPipelineExecutionId, String canaryConfigId, String user, String metricsAccountName, String storageAccountName, Map<String, Object> siteLocal, @NonNull CanaryConfig canaryConfig, @NonNull Map<String, CanaryScopePair> scopes, @NonNull CanaryClassifierThresholdsConfig scoreThresholds) {
        if (canaryConfig == null) {
            throw new IllegalArgumentException("canaryConfig is marked non-null but is null");
        }
        if (scopes == null) {
            throw new IllegalArgumentException("scopes is marked non-null but is null");
        }
        if (scoreThresholds == null) {
            throw new IllegalArgumentException("scoreThresholds is marked non-null but is null");
        }
        this.application = application;
        this.parentPipelineExecutionId = parentPipelineExecutionId;
        this.canaryConfigId = canaryConfigId;
        this.user = user;
        this.metricsAccountName = metricsAccountName;
        this.storageAccountName = storageAccountName;
        this.siteLocal = siteLocal;
        this.canaryConfig = canaryConfig;
        this.scopes = scopes;
        this.scoreThresholds = scoreThresholds;
    }

    public RunCanaryContext() {
    }

    public static class RunCanaryContextBuilder {
        private String application;
        private String parentPipelineExecutionId;
        private String canaryConfigId;
        private String user;
        private String metricsAccountName;
        private String storageAccountName;
        private Map<String, Object> siteLocal;
        private CanaryConfig canaryConfig;
        private Map<String, CanaryScopePair> scopes;
        private CanaryClassifierThresholdsConfig scoreThresholds;

        RunCanaryContextBuilder() {
        }

        public RunCanaryContextBuilder application(String application) {
            this.application = application;
            return this;
        }

        public RunCanaryContextBuilder parentPipelineExecutionId(String parentPipelineExecutionId) {
            this.parentPipelineExecutionId = parentPipelineExecutionId;
            return this;
        }

        public RunCanaryContextBuilder canaryConfigId(String canaryConfigId) {
            this.canaryConfigId = canaryConfigId;
            return this;
        }

        public RunCanaryContextBuilder user(String user) {
            this.user = user;
            return this;
        }

        public RunCanaryContextBuilder metricsAccountName(String metricsAccountName) {
            this.metricsAccountName = metricsAccountName;
            return this;
        }

        public RunCanaryContextBuilder storageAccountName(String storageAccountName) {
            this.storageAccountName = storageAccountName;
            return this;
        }

        public RunCanaryContextBuilder siteLocal(Map<String, Object> siteLocal) {
            this.siteLocal = siteLocal;
            return this;
        }

        public RunCanaryContextBuilder canaryConfig(@NonNull CanaryConfig canaryConfig) {
            if (canaryConfig == null) {
                throw new IllegalArgumentException("canaryConfig is marked non-null but is null");
            }
            this.canaryConfig = canaryConfig;
            return this;
        }

        public RunCanaryContextBuilder scopes(@NonNull Map<String, CanaryScopePair> scopes) {
            if (scopes == null) {
                throw new IllegalArgumentException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
            return this;
        }

        public RunCanaryContextBuilder scoreThresholds(@NonNull CanaryClassifierThresholdsConfig scoreThresholds) {
            if (scoreThresholds == null) {
                throw new IllegalArgumentException("scoreThresholds is marked non-null but is null");
            }
            this.scoreThresholds = scoreThresholds;
            return this;
        }

        public RunCanaryContext build() {
            return new RunCanaryContext(this.application, this.parentPipelineExecutionId, this.canaryConfigId, this.user, this.metricsAccountName, this.storageAccountName, this.siteLocal, this.canaryConfig, this.scopes, this.scoreThresholds);
        }

        public String toString() {
            return "RunCanaryContext.RunCanaryContextBuilder(application=" + this.application + ", parentPipelineExecutionId=" + this.parentPipelineExecutionId + ", canaryConfigId=" + this.canaryConfigId + ", user=" + this.user + ", metricsAccountName=" + this.metricsAccountName + ", storageAccountName=" + this.storageAccountName + ", siteLocal=" + String.valueOf(this.siteLocal) + ", canaryConfig=" + String.valueOf(this.canaryConfig) + ", scopes=" + String.valueOf(this.scopes) + ", scoreThresholds=" + String.valueOf(this.scoreThresholds) + ")";
        }
    }
}

