/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.controllers;

import com.netflix.kayenta.canary.CanaryConfig;
import com.netflix.kayenta.canary.CanaryConfigUpdateResponse;
import com.netflix.kayenta.canary.CanaryMetricConfig;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import com.netflix.kayenta.storage.ObjectType;
import com.netflix.kayenta.storage.StorageService;
import com.netflix.kayenta.storage.StorageServiceRepository;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/canaryConfig"})
public class CanaryConfigController {
    private static final Logger log = LoggerFactory.getLogger(CanaryConfigController.class);
    private static Pattern canaryConfigNamePattern = Pattern.compile("[A-Z,a-z,0-9,\\-,\\_]*");
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final StorageServiceRepository storageServiceRepository;
    private final boolean disableMetricNameValidation;

    @Autowired
    public CanaryConfigController(AccountCredentialsRepository accountCredentialsRepository, StorageServiceRepository storageServiceRepository, @Value(value="${kayenta.disable.metricname.validation:false}") boolean disableMetricNameValidation) {
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.storageServiceRepository = storageServiceRepository;
        this.disableMetricNameValidation = disableMetricNameValidation;
    }

    @ApiOperation(value="Retrieve a canary config from object storage")
    @RequestMapping(value={"/{canaryConfigId:.+}"}, method={RequestMethod.GET})
    public CanaryConfig loadCanaryConfig(@RequestParam(required=false) String configurationAccountName, @PathVariable String canaryConfigId) {
        String resolvedConfigurationAccountName = this.accountCredentialsRepository.getRequiredOneBy(configurationAccountName, AccountCredentials.Type.CONFIGURATION_STORE).getName();
        StorageService configurationService = this.storageServiceRepository.getRequiredOne(resolvedConfigurationAccountName);
        return (CanaryConfig)configurationService.loadObject(resolvedConfigurationAccountName, ObjectType.CANARY_CONFIG, canaryConfigId);
    }

    @ApiOperation(value="Write a canary config to object storage")
    @RequestMapping(consumes={"application/json"}, method={RequestMethod.POST})
    public CanaryConfigUpdateResponse storeCanaryConfig(@RequestParam(required=false) String configurationAccountName, @RequestBody CanaryConfig canaryConfig) throws IOException {
        String resolvedConfigurationAccountName = this.accountCredentialsRepository.getRequiredOneBy(configurationAccountName, AccountCredentials.Type.CONFIGURATION_STORE).getName();
        StorageService configurationService = this.storageServiceRepository.getRequiredOne(resolvedConfigurationAccountName);
        if (canaryConfig.getCreatedTimestamp() == null) {
            canaryConfig.setCreatedTimestamp(Long.valueOf(System.currentTimeMillis()));
        }
        if (canaryConfig.getUpdatedTimestamp() == null) {
            canaryConfig.setUpdatedTimestamp(canaryConfig.getCreatedTimestamp());
        }
        canaryConfig.setCreatedTimestampIso(Instant.ofEpochMilli(canaryConfig.getCreatedTimestamp()).toString());
        canaryConfig.setUpdatedTimestampIso(Instant.ofEpochMilli(canaryConfig.getUpdatedTimestamp()).toString());
        if (StringUtils.isEmpty((Object)canaryConfig.getId())) {
            canaryConfig = canaryConfig.toBuilder().id("" + UUID.randomUUID()).build();
        }
        String canaryConfigId = canaryConfig.getId();
        CanaryConfigController.validateNameAndApplicationAttributes(canaryConfig);
        this.validateMetricConfigNames(canaryConfig);
        try {
            configurationService.loadObject(resolvedConfigurationAccountName, ObjectType.CANARY_CONFIG, canaryConfigId);
            throw new IllegalArgumentException("Canary config '" + canaryConfigId + "' already exists.");
        }
        catch (NotFoundException e) {
            configurationService.storeObject(resolvedConfigurationAccountName, ObjectType.CANARY_CONFIG, canaryConfigId, (Object)canaryConfig, canaryConfig.getName() + ".json", false);
            return CanaryConfigUpdateResponse.builder().canaryConfigId(canaryConfigId).build();
        }
    }

    @ApiOperation(value="Update a canary config")
    @RequestMapping(value={"/{canaryConfigId:.+}"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public CanaryConfigUpdateResponse updateCanaryConfig(@RequestParam(required=false) String configurationAccountName, @PathVariable String canaryConfigId, @RequestBody CanaryConfig canaryConfig) throws IOException {
        String resolvedConfigurationAccountName = this.accountCredentialsRepository.getRequiredOneBy(configurationAccountName, AccountCredentials.Type.CONFIGURATION_STORE).getName();
        StorageService configurationService = this.storageServiceRepository.getRequiredOne(resolvedConfigurationAccountName);
        canaryConfig.setUpdatedTimestamp(Long.valueOf(System.currentTimeMillis()));
        canaryConfig.setUpdatedTimestampIso(Instant.ofEpochMilli(canaryConfig.getUpdatedTimestamp()).toString());
        CanaryConfigController.validateNameAndApplicationAttributes(canaryConfig);
        this.validateMetricConfigNames(canaryConfig);
        try {
            configurationService.loadObject(resolvedConfigurationAccountName, ObjectType.CANARY_CONFIG, canaryConfigId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Canary config '" + canaryConfigId + "' does not exist.");
        }
        if (StringUtils.isEmpty((Object)canaryConfig.getId())) {
            canaryConfig = canaryConfig.toBuilder().id(canaryConfigId).build();
        }
        configurationService.storeObject(resolvedConfigurationAccountName, ObjectType.CANARY_CONFIG, canaryConfigId, (Object)canaryConfig, canaryConfig.getName() + ".json", true);
        return CanaryConfigUpdateResponse.builder().canaryConfigId(canaryConfigId).build();
    }

    private static void validateNameAndApplicationAttributes(@RequestBody CanaryConfig canaryConfig) {
        if (StringUtils.isEmpty((Object)canaryConfig.getName())) {
            throw new IllegalArgumentException("Canary config must specify a name.");
        }
        if (canaryConfig.getApplications() == null || canaryConfig.getApplications().size() == 0) {
            throw new IllegalArgumentException("Canary config must specify at least one application.");
        }
        String canaryConfigName = canaryConfig.getName();
        if (!canaryConfigNamePattern.matcher(canaryConfigName).matches()) {
            throw new IllegalArgumentException("Canary config cannot be named '" + canaryConfigName + "'. Names must contain only letters, numbers, dashes (-) and underscores (_).");
        }
    }

    private void validateMetricConfigNames(CanaryConfig canaryConfig) {
        if (this.disableMetricNameValidation) {
            return;
        }
        List metrics = canaryConfig.getMetrics();
        if (CollectionUtils.isEmpty((Collection)metrics)) {
            return;
        }
        HashSet<String> metricNameSet = new HashSet<String>();
        for (CanaryMetricConfig metricConfig : metrics) {
            String metricName = metricConfig.getName();
            if (StringUtils.isEmpty((Object)metricName)) {
                throw new IllegalArgumentException("Metric config must specify a name.");
            }
            if (metricNameSet.contains(metricName)) {
                throw new IllegalArgumentException("Metric config name must be unique. '" + metricName + "' is duplicated.");
            }
            metricNameSet.add(metricName);
        }
    }

    @ApiOperation(value="Delete a canary config")
    @RequestMapping(value={"/{canaryConfigId:.+}"}, method={RequestMethod.DELETE})
    public void deleteCanaryConfig(@RequestParam(required=false) String configurationAccountName, @PathVariable String canaryConfigId, HttpServletResponse response) {
        String resolvedConfigurationAccountName = this.accountCredentialsRepository.getRequiredOneBy(configurationAccountName, AccountCredentials.Type.CONFIGURATION_STORE).getName();
        StorageService configurationService = this.storageServiceRepository.getRequiredOne(resolvedConfigurationAccountName);
        configurationService.deleteObject(resolvedConfigurationAccountName, ObjectType.CANARY_CONFIG, canaryConfigId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @ApiOperation(value="Retrieve a list of canary config ids and timestamps")
    @RequestMapping(method={RequestMethod.GET})
    public List<Map<String, Object>> listAllCanaryConfigs(@RequestParam(required=false) String configurationAccountName, @RequestParam(required=false, value="application") List<String> applications) {
        String resolvedConfigurationAccountName = this.accountCredentialsRepository.getRequiredOneBy(configurationAccountName, AccountCredentials.Type.CONFIGURATION_STORE).getName();
        StorageService configurationService = this.storageServiceRepository.getRequiredOne(resolvedConfigurationAccountName);
        return configurationService.listObjectKeys(resolvedConfigurationAccountName, ObjectType.CANARY_CONFIG, applications, false);
    }
}

