/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.netflix.kayenta.canary.CanaryAdhocExecutionRequest;
import com.netflix.kayenta.canary.CanaryConfig;
import com.netflix.kayenta.canary.CanaryExecutionRequest;
import com.netflix.kayenta.canary.CanaryExecutionResponse;
import com.netflix.kayenta.canary.CanaryExecutionStatusResponse;
import com.netflix.kayenta.canary.ExecutionMapper;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import com.netflix.kayenta.storage.ObjectType;
import com.netflix.kayenta.storage.StorageService;
import com.netflix.kayenta.storage.StorageServiceRepository;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionNotFoundException;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/canary"})
public class CanaryController {
    private static final Logger log = LoggerFactory.getLogger(CanaryController.class);
    private final String AD_HOC = "ad-hoc";
    private final ExecutionRepository executionRepository;
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final StorageServiceRepository storageServiceRepository;
    private final ExecutionMapper executionMapper;

    @Autowired
    public CanaryController(ExecutionRepository executionRepository, AccountCredentialsRepository accountCredentialsRepository, StorageServiceRepository storageServiceRepository, ExecutionMapper executionMapper) {
        this.executionRepository = executionRepository;
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.storageServiceRepository = storageServiceRepository;
        this.executionMapper = executionMapper;
    }

    @ApiOperation(value="Initiate a canary pipeline")
    @RequestMapping(value={"/{canaryConfigId:.+}"}, consumes={"application/json"}, method={RequestMethod.POST})
    public CanaryExecutionResponse initiateCanary(@RequestParam(required=false) String application, @RequestParam(required=false) String parentPipelineExecutionId, @RequestParam(required=false) String metricsAccountName, @RequestParam(required=false) String configurationAccountName, @RequestParam(required=false) String storageAccountName, @ApiParam @RequestBody CanaryExecutionRequest canaryExecutionRequest, @PathVariable String canaryConfigId) throws JsonProcessingException {
        String resolvedMetricsAccountName = this.accountCredentialsRepository.getRequiredOneBy(metricsAccountName, AccountCredentials.Type.METRICS_STORE).getName();
        String resolvedStorageAccountName = this.accountCredentialsRepository.getRequiredOneBy(storageAccountName, AccountCredentials.Type.OBJECT_STORE).getName();
        String resolvedConfigurationAccountName = this.accountCredentialsRepository.getRequiredOneBy(configurationAccountName, AccountCredentials.Type.CONFIGURATION_STORE).getName();
        StorageService configurationService = this.storageServiceRepository.getRequiredOne(resolvedConfigurationAccountName);
        CanaryConfig canaryConfig = (CanaryConfig)configurationService.loadObject(resolvedConfigurationAccountName, ObjectType.CANARY_CONFIG, canaryConfigId);
        return this.executionMapper.buildExecution(application, parentPipelineExecutionId, canaryConfigId, canaryConfig, resolvedConfigurationAccountName, resolvedMetricsAccountName, resolvedStorageAccountName, canaryExecutionRequest);
    }

    @ApiOperation(value="Initiate a canary pipeline with CanaryConfig provided")
    @RequestMapping(consumes={"application/json"}, method={RequestMethod.POST})
    public CanaryExecutionResponse initiateCanaryWithConfig(@RequestParam(required=false) String application, @RequestParam(required=false) String parentPipelineExecutionId, @RequestParam(required=false) String metricsAccountName, @RequestParam(required=false) String storageAccountName, @ApiParam @RequestBody CanaryAdhocExecutionRequest canaryAdhocExecutionRequest) throws JsonProcessingException {
        String resolvedMetricsAccountName = this.accountCredentialsRepository.getRequiredOneBy(metricsAccountName, AccountCredentials.Type.METRICS_STORE).getName();
        String resolvedStorageAccountName = this.accountCredentialsRepository.getRequiredOneBy(storageAccountName, AccountCredentials.Type.OBJECT_STORE).getName();
        if (canaryAdhocExecutionRequest.getCanaryConfig() == null) {
            throw new IllegalArgumentException("canaryConfig must be provided for ad-hoc requests");
        }
        if (canaryAdhocExecutionRequest.getExecutionRequest() == null) {
            throw new IllegalArgumentException("executionRequest must be provided for ad-hoc requests");
        }
        return this.executionMapper.buildExecution(Optional.ofNullable(application).orElse("ad-hoc"), parentPipelineExecutionId, "ad-hoc", canaryAdhocExecutionRequest.getCanaryConfig(), null, resolvedMetricsAccountName, resolvedStorageAccountName, canaryAdhocExecutionRequest.getExecutionRequest());
    }

    @ApiOperation(value="Retrieve status and results for a canary run")
    @RequestMapping(value={"/{canaryExecutionId:.+}"}, method={RequestMethod.GET})
    public CanaryExecutionStatusResponse getCanaryResults(@RequestParam(required=false) String storageAccountName, @PathVariable String canaryExecutionId) {
        String resolvedStorageAccountName = this.accountCredentialsRepository.getRequiredOneBy(storageAccountName, AccountCredentials.Type.OBJECT_STORE).getName();
        try {
            PipelineExecution pipeline = this.executionRepository.retrieve(ExecutionType.PIPELINE, canaryExecutionId);
            return this.executionMapper.fromExecution(pipeline);
        }
        catch (ExecutionNotFoundException e) {
            StorageService storageService = this.storageServiceRepository.getRequiredOne(resolvedStorageAccountName);
            return (CanaryExecutionStatusResponse)storageService.loadObject(resolvedStorageAccountName, ObjectType.CANARY_RESULT_ARCHIVE, canaryExecutionId);
        }
    }

    @ApiOperation(value="Retrieve a list of an application's canary results")
    @RequestMapping(value={"/executions"}, method={RequestMethod.GET})
    List<CanaryExecutionStatusResponse> getCanaryResultsByApplication(@RequestParam(required=false) String application, @RequestParam(value="limit", defaultValue="20") int limit, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="statuses", required=false) String statuses, @RequestParam(required=false) String storageAccountName) {
        String resolvedStorageAccountName = this.accountCredentialsRepository.getRequiredOneBy(storageAccountName, AccountCredentials.Type.OBJECT_STORE).getName();
        StorageService storageService = this.storageServiceRepository.getRequiredOne(resolvedStorageAccountName);
        if (StringUtils.isEmpty((CharSequence)statuses)) {
            statuses = Stream.of(ExecutionStatus.values()).map(s -> s.toString()).collect(Collectors.joining(","));
        }
        List statusesList = Stream.of(statuses.split(",")).map(s -> s.trim()).filter(s -> !StringUtils.isEmpty((CharSequence)s)).collect(Collectors.toList());
        ExecutionRepository.ExecutionCriteria executionCriteria = new ExecutionRepository.ExecutionCriteria().setPageSize(limit).setStatuses(statusesList).setPage(page);
        if (StringUtils.isEmpty((CharSequence)application)) {
            application = "ad-hoc";
        }
        String canaryPipelineConfigId = application + "-standard-canary-pipeline";
        List executions = (List)this.executionRepository.retrievePipelinesForPipelineConfigId(canaryPipelineConfigId, executionCriteria).toList().toBlocking().single();
        return executions.stream().map(arg_0 -> ((ExecutionMapper)this.executionMapper).fromExecution(arg_0)).collect(Collectors.toList());
    }
}

