/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.config;

import com.google.common.collect.ImmutableList;
import com.netflix.kayenta.filters.KayentaCorsFilter;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.web.interceptors.MetricsInterceptor;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(value={"com.netflix.kayenta.controllers"})
public class WebConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebConfiguration.class);
    @Autowired
    Registry registry;

    public void addInterceptors(InterceptorRegistry registry) {
        ImmutableList queryParamsToTag = ImmutableList.of((Object)"accountName", (Object)"configurationAccountName", (Object)"metricsAccountName", (Object)"storageAccountName", (Object)"application");
        registry.addInterceptor((HandlerInterceptor)new MetricsInterceptor(this.registry, "controller.invocations", Collections.emptyList(), (Collection)queryParamsToTag, (Collection)ImmutableList.of((Object)"BasicErrorController")));
    }

    @Bean
    FilterRegistrationBean simpleCORSFilter() {
        FilterRegistrationBean frb = new FilterRegistrationBean((Filter)new KayentaCorsFilter(), new ServletRegistrationBean[0]);
        frb.setOrder(Integer.MIN_VALUE);
        return frb;
    }
}

