/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.controllers;

import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.util.Collections;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ControllerExceptionHandler {
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={IllegalArgumentException.class})
    public Map handleException(IllegalArgumentException e) {
        return this.toErrorResponse(e);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NotFoundException.class})
    public Map handleException(NotFoundException e) {
        return this.toErrorResponse((Exception)((Object)e));
    }

    private Map toErrorResponse(Exception e) {
        return Collections.singletonMap("message", e.getMessage());
    }
}

