/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.controllers;

import com.netflix.kayenta.metrics.MetricSet;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import com.netflix.kayenta.storage.ObjectType;
import com.netflix.kayenta.storage.StorageService;
import com.netflix.kayenta.storage.StorageServiceRepository;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/metricSetList"})
public class MetricSetListController {
    private static final Logger log = LoggerFactory.getLogger(MetricSetListController.class);
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final StorageServiceRepository storageServiceRepository;

    @Autowired
    public MetricSetListController(AccountCredentialsRepository accountCredentialsRepository, StorageServiceRepository storageServiceRepository) {
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.storageServiceRepository = storageServiceRepository;
    }

    @ApiOperation(value="Retrieve a metric set list from object storage")
    @RequestMapping(value={"/{metricSetListId:.+}"}, method={RequestMethod.GET})
    public List<MetricSet> loadMetricSetList(@RequestParam(required=false) String accountName, @PathVariable String metricSetListId) {
        String resolvedAccountName = this.accountCredentialsRepository.getRequiredOneBy(accountName, AccountCredentials.Type.OBJECT_STORE).getName();
        StorageService storageService = this.storageServiceRepository.getRequiredOne(resolvedAccountName);
        return (List)storageService.loadObject(resolvedAccountName, ObjectType.METRIC_SET_LIST, metricSetListId);
    }

    @ApiOperation(value="Write a metric set list to object storage")
    @RequestMapping(consumes={"application/json"}, method={RequestMethod.POST})
    public Map storeMetricSetList(@RequestParam(required=false) String accountName, @RequestBody List<MetricSet> metricSetList) throws IOException {
        String resolvedAccountName = this.accountCredentialsRepository.getRequiredOneBy(accountName, AccountCredentials.Type.OBJECT_STORE).getName();
        StorageService storageService = this.storageServiceRepository.getRequiredOne(resolvedAccountName);
        String metricSetListId = "" + UUID.randomUUID();
        storageService.storeObject(resolvedAccountName, ObjectType.METRIC_SET_LIST, metricSetListId, metricSetList);
        return Collections.singletonMap("metricSetListId", metricSetListId);
    }

    @ApiOperation(value="Delete a metric set list")
    @RequestMapping(value={"/{metricSetListId:.+}"}, method={RequestMethod.DELETE})
    public void deleteMetricSetList(@RequestParam(required=false) String accountName, @PathVariable String metricSetListId, HttpServletResponse response) {
        String resolvedAccountName = this.accountCredentialsRepository.getRequiredOneBy(accountName, AccountCredentials.Type.OBJECT_STORE).getName();
        StorageService storageService = this.storageServiceRepository.getRequiredOne(resolvedAccountName);
        storageService.deleteObject(resolvedAccountName, ObjectType.METRIC_SET_LIST, metricSetListId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @ApiOperation(value="Retrieve a list of metric set list ids and timestamps")
    @RequestMapping(method={RequestMethod.GET})
    public List<Map<String, Object>> listAllMetricSetLists(@RequestParam(required=false) String accountName) {
        String resolvedAccountName = this.accountCredentialsRepository.getRequiredOneBy(accountName, AccountCredentials.Type.OBJECT_STORE).getName();
        StorageService storageService = this.storageServiceRepository.getRequiredOne(resolvedAccountName);
        return storageService.listObjectKeys(resolvedAccountName, ObjectType.METRIC_SET_LIST);
    }
}

