/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.controllers;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MetricsServiceDetail {
    @NonNull
    String name;
    @NonNull
    String type;
    @NonNull
    List<String> recommendedLocations;
    @NonNull
    List<String> locations;

    public static MetricsServiceDetailBuilder builder() {
        return new MetricsServiceDetailBuilder();
    }

    public String toString() {
        return "MetricsServiceDetail(name=" + this.getName() + ", type=" + this.getType() + ", recommendedLocations=" + this.getRecommendedLocations() + ", locations=" + this.getLocations() + ")";
    }

    public MetricsServiceDetail() {
    }

    public MetricsServiceDetail(@NonNull String name, @NonNull String type, @NonNull List<String> recommendedLocations, @NonNull List<String> locations) {
        if (name == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is marked non-null but is null");
        }
        if (recommendedLocations == null) {
            throw new IllegalArgumentException("recommendedLocations is marked non-null but is null");
        }
        if (locations == null) {
            throw new IllegalArgumentException("locations is marked non-null but is null");
        }
        this.name = name;
        this.type = type;
        this.recommendedLocations = recommendedLocations;
        this.locations = locations;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public List<String> getRecommendedLocations() {
        return this.recommendedLocations;
    }

    @NonNull
    public List<String> getLocations() {
        return this.locations;
    }

    public static class MetricsServiceDetailBuilder {
        private String name;
        private String type;
        private List<String> recommendedLocations;
        private List<String> locations;

        MetricsServiceDetailBuilder() {
        }

        public MetricsServiceDetailBuilder name(@NonNull String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public MetricsServiceDetailBuilder type(@NonNull String type) {
            if (type == null) {
                throw new IllegalArgumentException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public MetricsServiceDetailBuilder recommendedLocations(@NonNull List<String> recommendedLocations) {
            if (recommendedLocations == null) {
                throw new IllegalArgumentException("recommendedLocations is marked non-null but is null");
            }
            this.recommendedLocations = recommendedLocations;
            return this;
        }

        public MetricsServiceDetailBuilder locations(@NonNull List<String> locations) {
            if (locations == null) {
                throw new IllegalArgumentException("locations is marked non-null but is null");
            }
            this.locations = locations;
            return this;
        }

        public MetricsServiceDetail build() {
            return new MetricsServiceDetail(this.name, this.type, this.recommendedLocations, this.locations);
        }

        public String toString() {
            return "MetricsServiceDetail.MetricsServiceDetailBuilder(name=" + this.name + ", type=" + this.type + ", recommendedLocations=" + this.recommendedLocations + ", locations=" + this.locations + ")";
        }
    }
}

