/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.controllers;

import com.netflix.kayenta.metrics.MetricsService;
import com.netflix.kayenta.metrics.MetricsServiceRepository;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/metadata/metricsService"})
public class MetricsServiceMetadataController {
    private static final Logger log = LoggerFactory.getLogger(MetricsServiceMetadataController.class);
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final MetricsServiceRepository metricsServiceRepository;

    @Autowired
    public MetricsServiceMetadataController(AccountCredentialsRepository accountCredentialsRepository, MetricsServiceRepository metricsServiceRepository) {
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.metricsServiceRepository = metricsServiceRepository;
    }

    @ApiOperation(value="Retrieve a list of descriptors for use in populating the canary config ui")
    @RequestMapping(method={RequestMethod.GET})
    public List<Map> listMetadata(@RequestParam(required=false) String metricsAccountName, @RequestParam(required=false) String filter) throws IOException {
        String resolvedMetricsAccountName = this.accountCredentialsRepository.getRequiredOneBy(metricsAccountName, AccountCredentials.Type.METRICS_STORE).getName();
        MetricsService metricsService = this.metricsServiceRepository.getRequiredOne(resolvedMetricsAccountName);
        List matchingDescriptors = metricsService.getMetadata(resolvedMetricsAccountName, filter);
        if (StringUtils.isEmpty((CharSequence)filter)) {
            log.debug("Returned all {} descriptors via account {}.", (Object)matchingDescriptors.size(), (Object)resolvedMetricsAccountName);
        } else {
            log.debug("Matched {} descriptors via account {} using filter '{}'.", new Object[]{matchingDescriptors.size(), resolvedMetricsAccountName, filter});
        }
        return matchingDescriptors;
    }
}

