/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.controllers;

import com.netflix.kayenta.canary.CanaryArchiveResultUpdateResponse;
import com.netflix.kayenta.canary.CanaryExecutionStatusResponse;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import com.netflix.kayenta.storage.ObjectType;
import com.netflix.kayenta.storage.StorageService;
import com.netflix.kayenta.storage.StorageServiceRepository;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/canaryResultArchive"})
@Tag(name="/canaryResultArchive", description="Manipulate the archived canary result object store.  This should be used only for Kayenta maintenance.  Use the /canary endpoints for canary results.")
public class CanaryResultArchiveController {
    private static final Logger log = LoggerFactory.getLogger(CanaryResultArchiveController.class);
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final StorageServiceRepository storageServiceRepository;

    @Autowired
    public CanaryResultArchiveController(AccountCredentialsRepository accountCredentialsRepository, StorageServiceRepository storageServiceRepository) {
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.storageServiceRepository = storageServiceRepository;
    }

    @Operation(summary="Retrieve an archived canary result from object storage")
    @RequestMapping(value={"/{pipelineId:.+}"}, method={RequestMethod.GET})
    public CanaryExecutionStatusResponse loadArchivedCanaryResult(@RequestParam(required=false) String storageAccountName, @PathVariable String pipelineId) {
        String resolvedConfigurationAccountName = this.resolveStorageAccountName(storageAccountName);
        StorageService storageService = this.getStorageService(resolvedConfigurationAccountName);
        return (CanaryExecutionStatusResponse)storageService.loadObject(resolvedConfigurationAccountName, ObjectType.CANARY_RESULT_ARCHIVE, pipelineId);
    }

    @Operation(summary="Create an archived canary result to object storage")
    @RequestMapping(consumes={"application/json"}, method={RequestMethod.POST})
    public CanaryArchiveResultUpdateResponse storeArchivedCanaryResult(@RequestParam(required=false) String storageAccountName, @RequestParam(required=false) String pipelineId, @RequestBody CanaryExecutionStatusResponse canaryExecutionStatusResponse) throws IOException {
        String resolvedConfigurationAccountName = this.resolveStorageAccountName(storageAccountName);
        StorageService storageService = this.getStorageService(resolvedConfigurationAccountName);
        if (pipelineId == null) {
            pipelineId = String.valueOf(UUID.randomUUID());
        }
        try {
            storageService.loadObject(resolvedConfigurationAccountName, ObjectType.CANARY_RESULT_ARCHIVE, (String)pipelineId);
        }
        catch (NotFoundException e) {
            storageService.storeObject(resolvedConfigurationAccountName, ObjectType.CANARY_RESULT_ARCHIVE, (String)pipelineId, (Object)canaryExecutionStatusResponse, (String)pipelineId + ".json", false);
            return CanaryArchiveResultUpdateResponse.builder().pipelineId((String)pipelineId).build();
        }
        throw new IllegalArgumentException("Archived canary result '" + (String)pipelineId + "' already exists.");
    }

    @Operation(summary="Update an archived canary result in object storage")
    @RequestMapping(value={"/{pipelineId:.+}"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public CanaryArchiveResultUpdateResponse updateArchivedCanaryResult(@RequestParam(required=false) String storageAccountName, @PathVariable String pipelineId, @RequestBody CanaryExecutionStatusResponse canaryExecutionStatusResponse) throws IOException {
        String resolvedConfigurationAccountName = this.resolveStorageAccountName(storageAccountName);
        StorageService storageService = this.getStorageService(resolvedConfigurationAccountName);
        try {
            storageService.loadObject(resolvedConfigurationAccountName, ObjectType.CANARY_RESULT_ARCHIVE, pipelineId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Archived canary result '" + pipelineId + "' does not exist.");
        }
        storageService.storeObject(resolvedConfigurationAccountName, ObjectType.CANARY_RESULT_ARCHIVE, pipelineId, (Object)canaryExecutionStatusResponse, pipelineId + ".json", true);
        return CanaryArchiveResultUpdateResponse.builder().pipelineId(pipelineId).build();
    }

    @Operation(summary="Delete an archived canary result from object storage")
    @RequestMapping(value={"/{pipelineId:.+}"}, method={RequestMethod.DELETE})
    public void deleteArchivedCanaryResult(@RequestParam(required=false) String storageAccountName, @PathVariable String pipelineId, HttpServletResponse response) {
        String resolvedConfigurationAccountName = this.resolveStorageAccountName(storageAccountName);
        StorageService storageService = this.getStorageService(resolvedConfigurationAccountName);
        storageService.deleteObject(resolvedConfigurationAccountName, ObjectType.CANARY_RESULT_ARCHIVE, pipelineId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @Operation(summary="Retrieve a list of archived canary result ids in object storage")
    @RequestMapping(method={RequestMethod.GET})
    public List<Map<String, Object>> listAllCanaryArchivedResults(@RequestParam(required=false) String storageAccountName) {
        String resolvedConfigurationAccountName = this.resolveStorageAccountName(storageAccountName);
        StorageService storageService = this.getStorageService(resolvedConfigurationAccountName);
        return storageService.listObjectKeys(resolvedConfigurationAccountName, ObjectType.CANARY_RESULT_ARCHIVE);
    }

    private String resolveStorageAccountName(String storageAccountName) {
        return this.accountCredentialsRepository.getRequiredOneBy(storageAccountName, AccountCredentials.Type.OBJECT_STORE).getName();
    }

    private StorageService getStorageService(String resolvedStorageAccountName) {
        return this.storageServiceRepository.getRequiredOne(resolvedStorageAccountName);
    }
}

