/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.controllers;

import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/credentials"})
public class CredentialsController {
    private final AccountCredentialsRepository accountCredentialsRepository;

    @Autowired
    public CredentialsController(AccountCredentialsRepository accountCredentialsRepository) {
        this.accountCredentialsRepository = accountCredentialsRepository;
    }

    @Operation(summary="Retrieve a list of all configured credentials")
    @RequestMapping(method={RequestMethod.GET})
    Set<? extends AccountCredentials> list() {
        return this.accountCredentialsRepository.getAll();
    }

    @DeleteMapping(value={"/{accountName}"})
    public void deleteAccount(@PathVariable String accountName) {
        this.accountCredentialsRepository.deleteById(accountName);
    }
}

