/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.controllers;

import com.netflix.kayenta.metrics.MetricSetPair;
import com.netflix.kayenta.service.MetricSetPairListService;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/metricSetPairList"})
public class MetricSetPairListController {
    private static final Logger log = LoggerFactory.getLogger(MetricSetPairListController.class);
    private final MetricSetPairListService metricSetPairListService;

    @Autowired
    public MetricSetPairListController(MetricSetPairListService metricSetPairListService) {
        this.metricSetPairListService = metricSetPairListService;
    }

    @Operation(summary="Retrieve a metric set pair list from object storage")
    @RequestMapping(value={"/{metricSetPairListId:.+}"}, method={RequestMethod.GET})
    public List<MetricSetPair> loadMetricSetPairList(@RequestParam(required=false) String accountName, @PathVariable String metricSetPairListId) {
        return this.metricSetPairListService.loadMetricSetPairList(accountName, metricSetPairListId);
    }

    @Operation(summary="Retrieve a single metric set pair from a metricSetPairList from object storage")
    @RequestMapping(value={"/{metricSetPairListId:.+}/{metricSetPairId:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<MetricSetPair> loadMetricSetPair(@RequestParam(required=false) String accountName, @PathVariable String metricSetPairListId, @PathVariable String metricSetPairId) {
        return this.metricSetPairListService.loadMetricSetPair(accountName, metricSetPairListId, metricSetPairId).map(metricSetPair -> new ResponseEntity(metricSetPair, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @Operation(summary="Write a metric set pair list to object storage")
    @RequestMapping(consumes={"application/json"}, method={RequestMethod.POST})
    public Map storeMetricSetPairList(@RequestParam(required=false) String accountName, @RequestBody List<MetricSetPair> metricSetPairList) throws IOException {
        String metricSetPairListId = this.metricSetPairListService.storeMetricSetPairList(accountName, metricSetPairList);
        return Collections.singletonMap("metricSetPairListId", metricSetPairListId);
    }

    @Operation(summary="Delete a metric set pair list")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @RequestMapping(value={"/{metricSetPairListId:.+}"}, method={RequestMethod.DELETE})
    public void deleteMetricSetPairList(@RequestParam(required=false) String accountName, @PathVariable String metricSetPairListId) {
        this.metricSetPairListService.deleteMetricSetPairList(accountName, metricSetPairListId);
    }

    @Operation(summary="Retrieve a list of metric set pair list ids and timestamps")
    @RequestMapping(method={RequestMethod.GET})
    public List<Map<String, Object>> listAllMetricSetPairLists(@RequestParam(required=false) String accountName) {
        return this.metricSetPairListService.listAllMetricSetPairLists(accountName);
    }
}

