/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.kayenta.controllers;

import com.netflix.kayenta.controllers.MetricsServiceDetail;
import com.netflix.kayenta.security.AccountCredentials;
import com.netflix.kayenta.security.AccountCredentialsRepository;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/metricsServices"})
public class MetricsServicesController {
    private final AccountCredentialsRepository accountCredentialsRepository;

    @Autowired
    public MetricsServicesController(AccountCredentialsRepository accountCredentialsRepository) {
        this.accountCredentialsRepository = accountCredentialsRepository;
    }

    @Operation(summary="Retrieve a list of all configured metrics services")
    @RequestMapping(method={RequestMethod.GET})
    List<MetricsServiceDetail> list() {
        Set metricAccountCredentials = this.accountCredentialsRepository.getAllOf(AccountCredentials.Type.METRICS_STORE);
        return metricAccountCredentials.stream().map(account -> MetricsServiceDetail.builder().name(account.getName()).type(account.getType()).locations(account.getLocations()).recommendedLocations(account.getRecommendedLocations()).build()).collect(Collectors.toList());
    }
}

