/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.api.exceptions;

import java.util.List;
import java.util.Map;

public class ExceptionSummary {
    private String message;
    private String cause;
    private List<TraceDetail> details;
    private Boolean retryable;

    ExceptionSummary(String message, String cause, List<TraceDetail> details, Boolean retryable) {
        this.message = message;
        this.cause = cause;
        this.details = details;
        this.retryable = retryable;
    }

    public static ExceptionSummaryBuilder builder() {
        return new ExceptionSummaryBuilder();
    }

    public String getMessage() {
        return this.message;
    }

    public String getCause() {
        return this.cause;
    }

    public List<TraceDetail> getDetails() {
        return this.details;
    }

    public Boolean getRetryable() {
        return this.retryable;
    }

    public static class ExceptionSummaryBuilder {
        private String message;
        private String cause;
        private List<TraceDetail> details;
        private Boolean retryable;

        ExceptionSummaryBuilder() {
        }

        public ExceptionSummaryBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ExceptionSummaryBuilder cause(String cause) {
            this.cause = cause;
            return this;
        }

        public ExceptionSummaryBuilder details(List<TraceDetail> details) {
            this.details = details;
            return this;
        }

        public ExceptionSummaryBuilder retryable(Boolean retryable) {
            this.retryable = retryable;
            return this;
        }

        public ExceptionSummary build() {
            return new ExceptionSummary(this.message, this.cause, this.details, this.retryable);
        }

        public String toString() {
            return "ExceptionSummary.ExceptionSummaryBuilder(message=" + this.message + ", cause=" + this.cause + ", details=" + this.details + ", retryable=" + this.retryable + ")";
        }
    }

    public static class TraceDetail {
        private String message;
        private String userMessage;
        private Map<String, Object> additionalAttributes;
        private Boolean retryable;

        TraceDetail(String message, String userMessage, Map<String, Object> additionalAttributes, Boolean retryable) {
            this.message = message;
            this.userMessage = userMessage;
            this.additionalAttributes = additionalAttributes;
            this.retryable = retryable;
        }

        public static TraceDetailBuilder builder() {
            return new TraceDetailBuilder();
        }

        public String getMessage() {
            return this.message;
        }

        public String getUserMessage() {
            return this.userMessage;
        }

        public Map<String, Object> getAdditionalAttributes() {
            return this.additionalAttributes;
        }

        public Boolean getRetryable() {
            return this.retryable;
        }

        public static class TraceDetailBuilder {
            private String message;
            private String userMessage;
            private Map<String, Object> additionalAttributes;
            private Boolean retryable;

            TraceDetailBuilder() {
            }

            public TraceDetailBuilder message(String message) {
                this.message = message;
                return this;
            }

            public TraceDetailBuilder userMessage(String userMessage) {
                this.userMessage = userMessage;
                return this;
            }

            public TraceDetailBuilder additionalAttributes(Map<String, Object> additionalAttributes) {
                this.additionalAttributes = additionalAttributes;
                return this;
            }

            public TraceDetailBuilder retryable(Boolean retryable) {
                this.retryable = retryable;
                return this;
            }

            public TraceDetail build() {
                return new TraceDetail(this.message, this.userMessage, this.additionalAttributes, this.retryable);
            }

            public String toString() {
                return "ExceptionSummary.TraceDetail.TraceDetailBuilder(message=" + this.message + ", userMessage=" + this.userMessage + ", additionalAttributes=" + this.additionalAttributes + ", retryable=" + this.retryable + ")";
            }
        }
    }
}

