/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.artifacts.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Strings;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;
import org.apache.commons.lang3.StringUtils;

@JsonDeserialize(builder=ExpectedArtifactBuilder.class)
@NonnullByDefault
public final class ExpectedArtifact {
    private final Artifact matchArtifact;
    private final boolean usePriorArtifact;
    private final boolean useDefaultArtifact;
    @Nullable
    private final Artifact defaultArtifact;
    private final String id;
    @Nullable
    private final Artifact boundArtifact;

    @ParametersAreNullableByDefault
    private ExpectedArtifact(Artifact matchArtifact, boolean usePriorArtifact, boolean useDefaultArtifact, Artifact defaultArtifact, String id, Artifact boundArtifact) {
        this.matchArtifact = Optional.ofNullable(matchArtifact).orElseGet(() -> Artifact.builder().build());
        this.usePriorArtifact = usePriorArtifact;
        this.useDefaultArtifact = useDefaultArtifact;
        this.defaultArtifact = defaultArtifact;
        this.id = Strings.nullToEmpty((String)id);
        this.boundArtifact = boundArtifact;
    }

    public boolean matches(Artifact other) {
        String otherReference;
        String otherLocation;
        String otherVersion;
        String otherName;
        String otherType;
        String thisType = this.matchArtifact.getType();
        if (!this.matches(thisType, otherType = other.getType())) {
            return false;
        }
        String thisName = this.matchArtifact.getName();
        if (!this.matches(thisName, otherName = other.getName())) {
            return false;
        }
        String thisVersion = this.matchArtifact.getVersion();
        if (!this.matches(thisVersion, otherVersion = other.getVersion())) {
            return false;
        }
        String thisLocation = this.matchArtifact.getLocation();
        if (!this.matches(thisLocation, otherLocation = other.getLocation())) {
            return false;
        }
        String thisReference = this.matchArtifact.getReference();
        return this.matches(thisReference, otherReference = other.getReference());
    }

    private boolean matches(@Nullable String us, @Nullable String other) {
        return StringUtils.isEmpty((CharSequence)us) || other != null && this.patternMatches(us, other);
    }

    private boolean patternMatches(String us, String other) {
        return Pattern.compile(us).matcher(other).matches();
    }

    public static ExpectedArtifactBuilder builder() {
        return new ExpectedArtifactBuilder();
    }

    public ExpectedArtifactBuilder toBuilder() {
        return new ExpectedArtifactBuilder().matchArtifact(this.matchArtifact).usePriorArtifact(this.usePriorArtifact).useDefaultArtifact(this.useDefaultArtifact).defaultArtifact(this.defaultArtifact).id(this.id).boundArtifact(this.boundArtifact);
    }

    public Artifact getMatchArtifact() {
        return this.matchArtifact;
    }

    public boolean isUsePriorArtifact() {
        return this.usePriorArtifact;
    }

    public boolean isUseDefaultArtifact() {
        return this.useDefaultArtifact;
    }

    @Nullable
    public Artifact getDefaultArtifact() {
        return this.defaultArtifact;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public Artifact getBoundArtifact() {
        return this.boundArtifact;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpectedArtifact)) {
            return false;
        }
        ExpectedArtifact other = (ExpectedArtifact)o;
        Artifact this$matchArtifact = this.getMatchArtifact();
        Artifact other$matchArtifact = other.getMatchArtifact();
        if (this$matchArtifact == null ? other$matchArtifact != null : !((Object)this$matchArtifact).equals(other$matchArtifact)) {
            return false;
        }
        if (this.isUsePriorArtifact() != other.isUsePriorArtifact()) {
            return false;
        }
        if (this.isUseDefaultArtifact() != other.isUseDefaultArtifact()) {
            return false;
        }
        Artifact this$defaultArtifact = this.getDefaultArtifact();
        Artifact other$defaultArtifact = other.getDefaultArtifact();
        if (this$defaultArtifact == null ? other$defaultArtifact != null : !((Object)this$defaultArtifact).equals(other$defaultArtifact)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Artifact this$boundArtifact = this.getBoundArtifact();
        Artifact other$boundArtifact = other.getBoundArtifact();
        return !(this$boundArtifact == null ? other$boundArtifact != null : !((Object)this$boundArtifact).equals(other$boundArtifact));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Artifact $matchArtifact = this.getMatchArtifact();
        result = result * 59 + ($matchArtifact == null ? 43 : ((Object)$matchArtifact).hashCode());
        result = result * 59 + (this.isUsePriorArtifact() ? 79 : 97);
        result = result * 59 + (this.isUseDefaultArtifact() ? 79 : 97);
        Artifact $defaultArtifact = this.getDefaultArtifact();
        result = result * 59 + ($defaultArtifact == null ? 43 : ((Object)$defaultArtifact).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Artifact $boundArtifact = this.getBoundArtifact();
        result = result * 59 + ($boundArtifact == null ? 43 : ((Object)$boundArtifact).hashCode());
        return result;
    }

    public String toString() {
        return "ExpectedArtifact(matchArtifact=" + this.getMatchArtifact() + ", usePriorArtifact=" + this.isUsePriorArtifact() + ", useDefaultArtifact=" + this.isUseDefaultArtifact() + ", defaultArtifact=" + this.getDefaultArtifact() + ", id=" + this.getId() + ", boundArtifact=" + this.getBoundArtifact() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class ExpectedArtifactBuilder {
        private Artifact matchArtifact;
        private boolean usePriorArtifact;
        private boolean useDefaultArtifact;
        private Artifact defaultArtifact;
        private String id;
        private Artifact boundArtifact;

        ExpectedArtifactBuilder() {
        }

        public ExpectedArtifactBuilder matchArtifact(Artifact matchArtifact) {
            this.matchArtifact = matchArtifact;
            return this;
        }

        public ExpectedArtifactBuilder usePriorArtifact(boolean usePriorArtifact) {
            this.usePriorArtifact = usePriorArtifact;
            return this;
        }

        public ExpectedArtifactBuilder useDefaultArtifact(boolean useDefaultArtifact) {
            this.useDefaultArtifact = useDefaultArtifact;
            return this;
        }

        public ExpectedArtifactBuilder defaultArtifact(Artifact defaultArtifact) {
            this.defaultArtifact = defaultArtifact;
            return this;
        }

        public ExpectedArtifactBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ExpectedArtifactBuilder boundArtifact(Artifact boundArtifact) {
            this.boundArtifact = boundArtifact;
            return this;
        }

        public ExpectedArtifact build() {
            return new ExpectedArtifact(this.matchArtifact, this.usePriorArtifact, this.useDefaultArtifact, this.defaultArtifact, this.id, this.boundArtifact);
        }

        public String toString() {
            return "ExpectedArtifact.ExpectedArtifactBuilder(matchArtifact=" + this.matchArtifact + ", usePriorArtifact=" + this.usePriorArtifact + ", useDefaultArtifact=" + this.useDefaultArtifact + ", defaultArtifact=" + this.defaultArtifact + ", id=" + this.id + ", boundArtifact=" + this.boundArtifact + ")";
        }
    }
}

