/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.artifacts.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.netflix.spinnaker.kork.annotations.FieldsAreNullableByDefault;
import com.netflix.spinnaker.kork.annotations.MethodsReturnNonnullByDefault;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FieldsAreNullableByDefault
@JsonDeserialize(builder=ArtifactBuilder.class)
@JsonNaming
public final class Artifact {
    private final String type;
    private final boolean customKind;
    private final String name;
    private final String version;
    private final String location;
    private final String reference;
    @Nonnull
    private final Map<String, Object> metadata;
    private final String artifactAccount;
    private final String provenance;
    private final String uuid;

    private Artifact(String type, boolean customKind, String name, String version, String location, String reference, Map<String, Object> metadata, String artifactAccount, String provenance, String uuid) {
        this.type = type;
        this.customKind = customKind;
        this.name = name;
        this.version = version;
        this.location = location;
        this.reference = reference;
        this.metadata = Optional.ofNullable(metadata).map(HashMap::new).orElseGet(HashMap::new);
        this.artifactAccount = artifactAccount;
        this.provenance = provenance;
        this.uuid = uuid;
    }

    @Nullable
    public Object getMetadata(String key) {
        return this.metadata.get(key);
    }

    public static ArtifactBuilder builder() {
        return new ArtifactBuilder();
    }

    public ArtifactBuilder toBuilder() {
        return new ArtifactBuilder().type(this.type).customKind(this.customKind).name(this.name).version(this.version).location(this.location).reference(this.reference).metadata(this.metadata).artifactAccount(this.artifactAccount).provenance(this.provenance).uuid(this.uuid);
    }

    public String getType() {
        return this.type;
    }

    public boolean isCustomKind() {
        return this.customKind;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReference() {
        return this.reference;
    }

    @Nonnull
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String getArtifactAccount() {
        return this.artifactAccount;
    }

    public String getProvenance() {
        return this.provenance;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String toString() {
        return "Artifact(type=" + this.getType() + ", customKind=" + this.isCustomKind() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", location=" + this.getLocation() + ", reference=" + this.getReference() + ", metadata=" + this.getMetadata() + ", artifactAccount=" + this.getArtifactAccount() + ", provenance=" + this.getProvenance() + ", uuid=" + this.getUuid() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact)o;
        if (this.isCustomKind() != other.isCustomKind()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        Map<String, Object> this$metadata = this.getMetadata();
        Map<String, Object> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$artifactAccount = this.getArtifactAccount();
        String other$artifactAccount = other.getArtifactAccount();
        if (this$artifactAccount == null ? other$artifactAccount != null : !this$artifactAccount.equals(other$artifactAccount)) {
            return false;
        }
        String this$provenance = this.getProvenance();
        String other$provenance = other.getProvenance();
        if (this$provenance == null ? other$provenance != null : !this$provenance.equals(other$provenance)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        return !(this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCustomKind() ? 79 : 97);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        Map<String, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $artifactAccount = this.getArtifactAccount();
        result = result * 59 + ($artifactAccount == null ? 43 : $artifactAccount.hashCode());
        String $provenance = this.getProvenance();
        result = result * 59 + ($provenance == null ? 43 : $provenance.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        return result;
    }

    @JsonIgnoreProperties(value={"kind"})
    @JsonPOJOBuilder(withPrefix="")
    @MethodsReturnNonnullByDefault
    @JsonNaming
    public static class ArtifactBuilder {
        private String type;
        private boolean customKind;
        private String name;
        private String version;
        private String location;
        private String reference;
        private String artifactAccount;
        private String provenance;
        private String uuid;
        @Nonnull
        private Map<String, Object> metadata = new HashMap<String, Object>();

        public ArtifactBuilder metadata(@Nullable Map<String, Object> metadata) {
            this.metadata = Optional.ofNullable(metadata).orElseGet(HashMap::new);
            return this;
        }

        @JsonAnySetter
        public ArtifactBuilder putMetadata(String key, Object value) {
            this.metadata.put(key, value);
            return this;
        }

        ArtifactBuilder() {
        }

        public ArtifactBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ArtifactBuilder customKind(boolean customKind) {
            this.customKind = customKind;
            return this;
        }

        public ArtifactBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ArtifactBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ArtifactBuilder location(String location) {
            this.location = location;
            return this;
        }

        public ArtifactBuilder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public ArtifactBuilder artifactAccount(String artifactAccount) {
            this.artifactAccount = artifactAccount;
            return this;
        }

        public ArtifactBuilder provenance(String provenance) {
            this.provenance = provenance;
            return this;
        }

        public ArtifactBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Artifact build() {
            return new Artifact(this.type, this.customKind, this.name, this.version, this.location, this.reference, this.metadata, this.artifactAccount, this.provenance, this.uuid);
        }

        public String toString() {
            return "Artifact.ArtifactBuilder(type=" + this.type + ", customKind=" + this.customKind + ", name=" + this.name + ", version=" + this.version + ", location=" + this.location + ", reference=" + this.reference + ", metadata=" + this.metadata + ", artifactAccount=" + this.artifactAccount + ", provenance=" + this.provenance + ", uuid=" + this.uuid + ")";
        }
    }
}

