/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.artifacts.artifactstore;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.netflix.spinnaker.kork.artifacts.ArtifactTypes;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStore;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.IOException;

public class EmbeddedArtifactSerializer
extends StdSerializer<Artifact> {
    private final ObjectMapper defaultObjectMapper;
    private final ArtifactStore storage;

    public EmbeddedArtifactSerializer(ObjectMapper defaultObjectMapper, ArtifactStore storage) {
        super(Artifact.class);
        this.defaultObjectMapper = defaultObjectMapper;
        this.storage = storage;
    }

    public void serialize(Artifact artifact, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (!EmbeddedArtifactSerializer.shouldStoreArtifact(artifact)) {
            this.defaultObjectMapper.writeValue(gen, (Object)artifact);
            return;
        }
        Artifact stored = this.storage.store(artifact);
        this.defaultObjectMapper.writeValue(gen, (Object)stored);
    }

    private static boolean shouldStoreArtifact(Artifact artifact) {
        String ref = artifact.getReference();
        return ArtifactTypes.EMBEDDED_BASE64.getMimeType().equals(artifact.getType()) && ref != null && !ref.isEmpty();
    }
}

