/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.artifacts.artifactstore;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStore;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStoreConfigurationProperties;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStoreURIBuilder;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStoreURISHA256Builder;
import com.netflix.spinnaker.kork.artifacts.artifactstore.s3.S3ArtifactStore;
import java.net.URI;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.PermissionEvaluator;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

@Configuration
@ConditionalOnExpression(value="${artifact-store.enabled:false}")
@EnableConfigurationProperties(value={ArtifactStoreConfigurationProperties.class})
public class ArtifactStoreConfiguration {
    private static final Logger log = LogManager.getLogger(ArtifactStoreConfiguration.class);

    @Bean
    public ObjectMapper artifactObjectMapper() {
        return new ObjectMapper();
    }

    @Bean
    public ArtifactStoreURIBuilder artifactStoreURIBuilder() {
        return new ArtifactStoreURISHA256Builder();
    }

    @Bean
    @ConditionalOnExpression(value="${artifact-store.s3.enabled:false}")
    public ArtifactStore s3ArtifactStore(Optional<PermissionEvaluator> permissionEvaluator, ArtifactStoreConfigurationProperties properties, @Qualifier(value="artifactS3Client") S3Client s3Client, ArtifactStoreURIBuilder artifactStoreURIBuilder) {
        if (permissionEvaluator.isEmpty()) {
            log.warn("PermissionEvaluator is not present. This means anyone will be able to access any artifact in the store.");
        }
        S3ArtifactStore storage = new S3ArtifactStore(s3Client, permissionEvaluator.orElse(null), properties.getS3().getBucket(), artifactStoreURIBuilder, properties.getApplicationsRegex());
        ArtifactStore.setInstance(storage);
        return storage;
    }

    @Bean
    @ConditionalOnExpression(value="${artifact-store.s3.enabled:false}")
    public S3Client artifactS3Client(ArtifactStoreConfigurationProperties properties) {
        S3ClientBuilder builder = S3Client.builder();
        ArtifactStoreConfigurationProperties.S3ClientConfig config = properties.getS3();
        if (config.getUrl() != null) {
            builder = (S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)builder.credentialsProvider(this.getCredentialsProvider(config))).forcePathStyle(Boolean.valueOf(config.isForcePathStyle()))).endpointOverride(URI.create(config.getUrl()));
        } else if (config.getProfile() != null) {
            builder = (S3ClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)config.getProfile()));
        }
        if (config.getRegion() != null) {
            builder = (S3ClientBuilder)builder.region(Region.of((String)config.getRegion()));
        }
        return (S3Client)builder.build();
    }

    private AwsCredentialsProvider getCredentialsProvider(ArtifactStoreConfigurationProperties.S3ClientConfig config) {
        if (config.getAccessKey() != null) {
            return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)config.getAccessKey(), (String)config.getSecretKey()));
        }
        return AnonymousCredentialsProvider.create();
    }
}

