/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.artifacts.artifactstore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.netflix.spinnaker.kork.artifacts.ArtifactTypes;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactDecorator;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactReferenceURI;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStore;
import com.netflix.spinnaker.kork.artifacts.artifactstore.exceptions.ArtifactStoreIOException;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Qualifier;

public class ArtifactDeserializer
extends StdDeserializer<Artifact> {
    private final ObjectMapper defaultObjectMapper;
    private final ArtifactStore storage;

    public ArtifactDeserializer(@Qualifier(value="artifactObjectMapper") ObjectMapper defaultObjectMapper, ArtifactStore storage) {
        super(Artifact.class);
        this.defaultObjectMapper = defaultObjectMapper;
        this.storage = storage;
    }

    public Artifact deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        Artifact artifact = (Artifact)this.defaultObjectMapper.readValue(parser, Artifact.class);
        if (ArtifactTypes.REMOTE_BASE64.getMimeType().equals(artifact.getType())) {
            return ArtifactStoreIOException.throwIOException(() -> this.storage.get(ArtifactReferenceURI.parse(artifact.getReference()), new ArtifactMergeReferenceDecorator(artifact)));
        }
        return artifact;
    }

    public static class ArtifactMergeReferenceDecorator
    implements ArtifactDecorator {
        private final Artifact artifactToCopy;

        private ArtifactMergeReferenceDecorator(Artifact artifactToCopy) {
            this.artifactToCopy = artifactToCopy;
        }

        @Override
        public Artifact.ArtifactBuilder decorate(Artifact.ArtifactBuilder builder) {
            Artifact retrieved = builder.build();
            return this.artifactToCopy.toBuilder().reference(retrieved.getReference());
        }
    }
}

