/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.artifacts.parsing;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hubspot.jinjava.Jinjava;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.kork.artifacts.parsing.ArtifactExtractor;
import com.netflix.spinnaker.kork.artifacts.parsing.JinjavaFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JinjaArtifactExtractor
implements ArtifactExtractor {
    private static final Logger log = LoggerFactory.getLogger(JinjaArtifactExtractor.class);
    private final JinjavaFactory jinjavaFactory;
    private final ObjectMapper objectMapper;
    private final String jinjaTemplate;
    private static final TypeReference<List<Artifact>> artifactListReference = new TypeReference<List<Artifact>>(){};
    private static final TypeReference<Map<String, ?>> stringMapReference = new TypeReference<Map<String, ?>>(){};

    private JinjaArtifactExtractor(String jinjaTemplate, JinjavaFactory jinjavaFactory, ObjectMapper objectMapper) {
        this.jinjaTemplate = jinjaTemplate;
        this.jinjavaFactory = jinjavaFactory;
        this.objectMapper = objectMapper;
    }

    @Override
    public List<Artifact> getArtifacts(String messagePayload) {
        if (StringUtils.isEmpty((CharSequence)messagePayload)) {
            return Collections.emptyList();
        }
        return this.readArtifactList(this.jinjaTransform(messagePayload));
    }

    private String jinjaTransform(String messagePayload) {
        if (StringUtils.isEmpty((CharSequence)this.jinjaTemplate)) {
            return messagePayload;
        }
        Jinjava jinja = this.jinjavaFactory.create();
        Map<String, ?> context = this.readMapValue(messagePayload);
        return jinja.render(this.jinjaTemplate, context);
    }

    private Map<String, ?> readMapValue(String messagePayload) {
        try {
            return (Map)this.objectMapper.readValue(messagePayload, stringMapReference);
        }
        catch (IOException ioe) {
            log.error(messagePayload);
            throw new RuntimeException(ioe);
        }
    }

    private List<Artifact> readArtifactList(String hydratedTemplate) {
        try {
            return (List)this.objectMapper.readValue(hydratedTemplate, artifactListReference);
        }
        catch (IOException ioe) {
            log.warn("Unable to parse artifact from {}", (Object)hydratedTemplate, (Object)ioe);
            return Collections.emptyList();
        }
    }

    public static class Factory {
        private final JinjavaFactory jinjavaFactory;
        private final ObjectMapper objectMapper = new ObjectMapper();

        public JinjaArtifactExtractor create(InputStream templateStream) {
            String template = this.readTemplateStream(templateStream);
            return this.create(template);
        }

        public JinjaArtifactExtractor create(String template) {
            return new JinjaArtifactExtractor(template, this.jinjavaFactory, this.objectMapper);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private String readTemplateStream(InputStream templateStream) {
            if (templateStream == null) {
                return "";
            }
            try (InputStreamReader isr = new InputStreamReader((InputStream)new BufferedInputStream(templateStream), Charset.forName("UTF-8"));){
                String string;
                try (StringWriter sw = new StringWriter();){
                    int charsRead;
                    char[] buf = new char[4096];
                    while ((charsRead = isr.read(buf)) != -1) {
                        sw.write(buf, 0, charsRead);
                    }
                    string = sw.toString();
                }
                return string;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        public Factory(JinjavaFactory jinjavaFactory) {
            this.jinjavaFactory = jinjavaFactory;
        }
    }
}

