/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.artifacts.artifactstore;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;

public class ArtifactReferenceURI {
    private final String scheme;
    private final List<String> uriPaths;

    public String uri() {
        return String.format("%s://%s", this.scheme, this.paths());
    }

    public String paths() {
        return Strings.join(this.uriPaths, (char)'/');
    }

    public static ArtifactReferenceURI parse(String reference) {
        String noSchemeURI = StringUtils.removeStart((String)reference, (String)"ref://");
        String[] paths = StringUtils.split((String)noSchemeURI, (char)'/');
        return ArtifactReferenceURI.builder().scheme("ref").uriPaths(Arrays.asList(paths)).build();
    }

    ArtifactReferenceURI(String scheme, List<String> uriPaths) {
        this.scheme = scheme;
        this.uriPaths = uriPaths;
    }

    public static ArtifactReferenceURIBuilder builder() {
        return new ArtifactReferenceURIBuilder();
    }

    public String getScheme() {
        return this.scheme;
    }

    public List<String> getUriPaths() {
        return this.uriPaths;
    }

    public static class ArtifactReferenceURIBuilder {
        private String scheme;
        private List<String> uriPaths;

        ArtifactReferenceURIBuilder() {
        }

        public ArtifactReferenceURIBuilder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public ArtifactReferenceURIBuilder uriPaths(List<String> uriPaths) {
            this.uriPaths = uriPaths;
            return this;
        }

        public ArtifactReferenceURI build() {
            return new ArtifactReferenceURI(this.scheme, this.uriPaths);
        }

        public String toString() {
            return "ArtifactReferenceURI.ArtifactReferenceURIBuilder(scheme=" + this.scheme + ", uriPaths=" + this.uriPaths + ")";
        }
    }
}

