/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.artifacts.artifactstore.s3;

import com.netflix.spinnaker.kork.artifacts.ArtifactTypes;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactDecorator;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactReferenceURI;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStoreGetter;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import com.netflix.spinnaker.security.UserPermissionEvaluator;
import java.io.Serializable;
import java.util.Base64;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.authentication.AuthenticationServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.Tag;

public class S3ArtifactStoreGetter
implements ArtifactStoreGetter {
    private static final Logger log = LogManager.getLogger(S3ArtifactStoreGetter.class);
    private final S3Client s3Client;
    private final UserPermissionEvaluator userPermissionEvaluator;
    private final String bucket;

    public S3ArtifactStoreGetter(S3Client s3Client, UserPermissionEvaluator userPermissionEvaluator, String bucket) {
        this.s3Client = s3Client;
        this.bucket = bucket;
        this.userPermissionEvaluator = userPermissionEvaluator;
    }

    @Override
    public Artifact get(ArtifactReferenceURI uri, ArtifactDecorator ... decorators) {
        this.hasAuthorization(uri, (String)AuthenticatedRequest.getSpinnakerUser().orElseThrow(() -> new NoSuchElementException("Could not authenticate due to missing user id")));
        GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket).key(uri.paths()).build();
        ResponseBytes resp = this.s3Client.getObjectAsBytes(request);
        Artifact.ArtifactBuilder builder = Artifact.builder().type(ArtifactTypes.REMOTE_BASE64.getMimeType()).reference(Base64.getEncoder().encodeToString(resp.asByteArray()));
        if (decorators == null) {
            return builder.build();
        }
        for (ArtifactDecorator decorator : decorators) {
            builder = decorator.decorate(builder);
        }
        return builder.build();
    }

    private void hasAuthorization(ArtifactReferenceURI uri, String userId) {
        GetObjectTaggingRequest request = (GetObjectTaggingRequest)GetObjectTaggingRequest.builder().bucket(this.bucket).key(uri.paths()).build();
        GetObjectTaggingResponse resp = this.s3Client.getObjectTagging(request);
        Tag tag = resp.tagSet().stream().filter(t -> t.key().equals("application")).findFirst().orElse(null);
        if (tag == null || this.userPermissionEvaluator != null && !this.userPermissionEvaluator.hasPermission(userId, (Serializable)((Object)tag.value()), "application", (Object)"READ")) {
            log.error("Could not authenticate to retrieve artifact user={} applicationOfStoredArtifact={}", (Object)userId, (Object)(tag == null ? "(none)" : tag.value()));
            throw new AuthenticationServiceException(userId + " does not have permission to access this artifact");
        }
    }
}

