/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.artifacts.artifactstore;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;

public class ArtifactReferenceURI {
    private static final String uriScheme = "ref://";
    private final List<String> uriPaths;

    public String uri() {
        return uriScheme + this.paths();
    }

    public String paths() {
        return Strings.join(this.uriPaths, (char)'/');
    }

    public static boolean is(String reference) {
        return reference.startsWith(uriScheme);
    }

    public static ArtifactReferenceURI parse(String reference) {
        String noSchemeURI = StringUtils.removeStart((String)reference, (String)uriScheme);
        String[] paths = StringUtils.split((String)noSchemeURI, (char)'/');
        return ArtifactReferenceURI.builder().uriPaths(Arrays.asList(paths)).build();
    }

    ArtifactReferenceURI(List<String> uriPaths) {
        this.uriPaths = uriPaths;
    }

    public static ArtifactReferenceURIBuilder builder() {
        return new ArtifactReferenceURIBuilder();
    }

    public List<String> getUriPaths() {
        return this.uriPaths;
    }

    public static class ArtifactReferenceURIBuilder {
        private List<String> uriPaths;

        ArtifactReferenceURIBuilder() {
        }

        public ArtifactReferenceURIBuilder uriPaths(List<String> uriPaths) {
            this.uriPaths = uriPaths;
            return this;
        }

        public ArtifactReferenceURI build() {
            return new ArtifactReferenceURI(this.uriPaths);
        }

        public String toString() {
            return "ArtifactReferenceURI.ArtifactReferenceURIBuilder(uriPaths=" + this.uriPaths + ")";
        }
    }
}

