/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.artifacts.artifactstore;

import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactDecorator;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactReferenceURI;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStoreGetter;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStoreStorer;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArtifactStore
implements ArtifactStoreGetter,
ArtifactStoreStorer {
    private static final Logger log = LogManager.getLogger(ArtifactStore.class);
    private static volatile ArtifactStore instance = null;
    private final ArtifactStoreGetter artifactStoreGetter;
    private final ArtifactStoreStorer artifactStoreStorer;

    public ArtifactStore(ArtifactStoreGetter artifactStoreGetter, ArtifactStoreStorer artifactStoreStorer) {
        this.artifactStoreGetter = artifactStoreGetter;
        this.artifactStoreStorer = artifactStoreStorer;
    }

    @Override
    public Artifact store(Artifact artifact) {
        return this.artifactStoreStorer.store(artifact);
    }

    @Override
    public Artifact get(ArtifactReferenceURI uri, ArtifactDecorator ... decorators) {
        return this.artifactStoreGetter.get(uri, decorators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(ArtifactStore storage) {
        Class<ArtifactStore> clazz = ArtifactStore.class;
        synchronized (ArtifactStore.class) {
            if (instance == null) {
                instance = storage;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            log.warn("Multiple attempts in setting the singleton artifact store");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static ArtifactStore getInstance() {
        return instance;
    }
}

