/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.artifacts.artifactstore;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStore;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStoreConfigurationProperties;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStoreGetter;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStoreStorer;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStoreURIBuilder;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStoreURISHA256Builder;
import com.netflix.spinnaker.kork.artifacts.artifactstore.NoopArtifactStoreGetter;
import com.netflix.spinnaker.kork.artifacts.artifactstore.NoopArtifactStoreStorer;
import com.netflix.spinnaker.kork.artifacts.artifactstore.s3.S3ArtifactStoreConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={ArtifactStoreConfigurationProperties.class})
@Import(value={S3ArtifactStoreConfiguration.class})
public class ArtifactStoreConfiguration {
    @Bean
    public ObjectMapper artifactObjectMapper() {
        return new ObjectMapper();
    }

    @Bean
    public ArtifactStoreURIBuilder artifactStoreURIBuilder() {
        return new ArtifactStoreURISHA256Builder();
    }

    @ConditionalOnMissingBean(value={ArtifactStoreGetter.class})
    @Bean
    public ArtifactStoreGetter artifactStoreGetter() {
        return new NoopArtifactStoreGetter();
    }

    @ConditionalOnMissingBean(value={ArtifactStoreStorer.class})
    @Bean
    public ArtifactStoreStorer artifactStoreStorer() {
        return new NoopArtifactStoreStorer();
    }

    @Bean
    public ArtifactStore artifactStore(ArtifactStoreGetter artifactStoreGetter, ArtifactStoreStorer artifactStoreStorer) {
        ArtifactStore artifactStore = new ArtifactStore(artifactStoreGetter, artifactStoreStorer);
        ArtifactStore.setInstance(artifactStore);
        return artifactStore;
    }
}

