/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.artifacts.artifactstore;

import com.google.common.hash.Hashing;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactReferenceURI;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStoreURIBuilder;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class ArtifactStoreURISHA256Builder
extends ArtifactStoreURIBuilder {
    @Override
    public ArtifactReferenceURI buildArtifactURI(String context, Artifact artifact) {
        String ref = artifact.getReference();
        if (ref == null) {
            throw new NullPointerException("Artifact reference cannot be null");
        }
        List<String> uriPaths = List.of(context, Hashing.sha256().hashBytes(artifact.getReference().getBytes(StandardCharsets.UTF_8)).toString());
        return ArtifactReferenceURI.builder().uriPaths(uriPaths).build();
    }

    @Override
    public ArtifactReferenceURI buildURIFromPaths(String context, String ... paths) {
        ArrayList<String> uriPaths = new ArrayList<String>();
        uriPaths.add(context);
        uriPaths.addAll(List.of(paths));
        return ArtifactReferenceURI.builder().uriPaths(uriPaths).build();
    }
}

