/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.aws.bastion;

import com.amazonaws.util.IOUtils;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteCredentialsSupport {
    private static final JSch jsch = new JSch();
    private static final Logger log = LoggerFactory.getLogger(RemoteCredentialsSupport.class);
    private static final IdentityRepository identityRepository;
    private static final ObjectMapper objectMapper;

    RemoteCredentialsSupport() {
    }

    static RemoteCredentials getRemoteCredentials(String command, String user, String host, int port) {
        RemoteCredentials remoteCredentials = new RemoteCredentials();
        try {
            Session session = jsch.getSession(user, host, port);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("PreferredAuthentications", "publickey");
            config.put("HashKnownHosts", "yes");
            session.setConfig(config);
            session.setPassword("");
            session.connect();
            ChannelExec channel = (ChannelExec)session.openChannel("exec");
            InputStream is = channel.getInputStream();
            channel.setCommand(command);
            channel.connect();
            String output = IOUtils.toString((InputStream)is);
            log.debug("Remote credentials: {}", (Object)output);
            channel.disconnect();
            session.disconnect();
            output = output.replace("\n", "");
            remoteCredentials = (RemoteCredentials)objectMapper.readValue(output, RemoteCredentials.class);
        }
        catch (Exception e) {
            log.error("Remote SSH execution failed.", (Throwable)e);
        }
        return remoteCredentials;
    }

    static {
        objectMapper = new ObjectMapper();
        RemoteIdentityRepository ir = null;
        try {
            ir = new RemoteIdentityRepository(ConnectorFactory.getDefault().createConnector());
        }
        catch (AgentProxyException e) {
            log.error("Error setting up default remote identity connector", (Throwable)e);
        }
        identityRepository = ir;
        jsch.setIdentityRepository(identityRepository);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
    }

    static class RemoteCredentials {
        private String accessKeyId;
        private String secretAccessKey;
        private String token;
        private String expiration;

        RemoteCredentials() {
        }

        String getAccessKeyId() {
            return this.accessKeyId;
        }

        public void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        String getSecretAccessKey() {
            return this.secretAccessKey;
        }

        public void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        String getExpiration() {
            return this.expiration;
        }

        public void setExpiration(String expiration) {
            this.expiration = expiration;
        }
    }
}

