/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.aws.bastion;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.netflix.spinnaker.kork.aws.bastion.RemoteCredentialsSupport;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BastionCredentialsProvider
implements AWSCredentialsProvider {
    private static final String CREDENTIALS_BASE_URL = "http://169.254.169.254/latest/meta-data/iam/security-credentials";
    private static final Logger log = LoggerFactory.getLogger(BastionCredentialsProvider.class);
    private final String user;
    private final String host;
    private final Integer port;
    private final String proxyCluster;
    private final String proxyRegion;
    private final String iamRole;
    private Date expiration;
    private AWSCredentials credentials;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);

    public BastionCredentialsProvider(String user, String host, Integer port, String proxyCluster, String proxyRegion, String iamRole) {
        this.user = user == null ? (String)System.getProperties().get("user.name") : user;
        this.host = host;
        this.port = port;
        this.proxyCluster = proxyCluster;
        this.proxyRegion = proxyRegion;
        this.iamRole = iamRole;
    }

    public AWSCredentials getCredentials() {
        if (this.expiration == null || this.expiration.before(new Date())) {
            this.credentials = this.getRemoteCredentials();
        }
        return this.credentials;
    }

    public void refresh() {
        this.credentials = this.getRemoteCredentials();
    }

    private AWSCredentials getRemoteCredentials() {
        String command = String.format("oq-ssh -r %s %s,0 'curl -s %s/%s'", this.proxyRegion, this.proxyCluster, CREDENTIALS_BASE_URL, this.iamRole);
        RemoteCredentialsSupport.RemoteCredentials credentials = RemoteCredentialsSupport.getRemoteCredentials(command, this.user, this.host, this.port);
        try {
            this.expiration = this.format.parse(credentials.getExpiration());
        }
        catch (ParseException e) {
            log.error("Failed to parse credentials expiration {}", (Object)credentials.getExpiration(), (Object)e);
            throw new IllegalStateException(e);
        }
        return new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getToken());
    }
}

