/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import java.util.Optional;

public class AwsMetricsSupport {
    private static final String DEFAULT_UNKNOWN = "UNKNOWN";

    static String[] buildExceptionTags(AmazonWebServiceRequest originalRequest, Exception exception) {
        AmazonServiceException ase = AwsMetricsSupport.amazonServiceException(exception);
        String targetAccountId = DEFAULT_UNKNOWN;
        if (ase.getHttpHeaders() != null) {
            targetAccountId = (String)ase.getHttpHeaders().get("targetAccountId");
        }
        return new String[]{"requestType", originalRequest.getClass().getSimpleName(), "statusCode", Integer.toString(ase.getStatusCode()), "errorCode", Optional.ofNullable(ase.getErrorCode()).orElse(DEFAULT_UNKNOWN), "serviceName", Optional.ofNullable(ase.getServiceName()).orElse(DEFAULT_UNKNOWN), "errorType", Optional.ofNullable(ase.getErrorType()).orElse(AmazonServiceException.ErrorType.Unknown).name(), "accountId", Optional.ofNullable(targetAccountId).orElse(DEFAULT_UNKNOWN)};
    }

    static AmazonServiceException amazonServiceException(Exception exception) {
        return AwsMetricsSupport.amazonServiceException(exception, DEFAULT_UNKNOWN, -1);
    }

    static AmazonServiceException amazonServiceException(Exception exception, String serviceName, int statusCode) {
        if (exception instanceof AmazonServiceException) {
            return (AmazonServiceException)exception;
        }
        AmazonServiceException ase = new AmazonServiceException(exception.getMessage(), exception);
        ase.setStatusCode(statusCode);
        ase.setErrorCode(DEFAULT_UNKNOWN);
        ase.setServiceName(serviceName);
        ase.setErrorType(AmazonServiceException.ErrorType.Unknown);
        return ase;
    }
}

