/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryPolicy;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.aws.AwsMetricsSupport;
import java.util.Objects;

public class InstrumentedRetryCondition
implements RetryPolicy.RetryCondition {
    private final Registry registry;
    private final RetryPolicy.RetryCondition delegate;

    public InstrumentedRetryCondition(Registry registry) {
        this(registry, PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION);
    }

    public InstrumentedRetryCondition(Registry registry, RetryPolicy.RetryCondition delegate) {
        this.registry = Objects.requireNonNull(registry, "registry");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
        boolean result = this.delegate.shouldRetry(originalRequest, exception, retriesAttempted);
        if (result) {
            this.registry.counter("AWS_retries", AwsMetricsSupport.buildExceptionTags(originalRequest, (Exception)exception)).increment();
        }
        return result;
    }
}

