/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.aws.bastion;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.netflix.spinnaker.kork.aws.bastion.BastionCredentialsProvider;
import com.netflix.spinnaker.kork.aws.bastion.BastionProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"bastion.enabled"})
@EnableConfigurationProperties(value={BastionProperties.class})
public class BastionConfig {
    @Bean
    public AWSCredentialsProvider bastionCredentialsProvider(BastionProperties bastionConfiguration) {
        BastionCredentialsProvider provider = new BastionCredentialsProvider(bastionConfiguration.getUser(), bastionConfiguration.getHost(), bastionConfiguration.getPort(), bastionConfiguration.getProxyCluster(), bastionConfiguration.getProxyRegion(), bastionConfiguration.getAccountIamRole());
        provider.refresh();
        return provider;
    }
}

