/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryPolicy;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.aws.AwsMetricsSupport;
import java.util.Objects;

public class InstrumentedBackoffStrategy
implements RetryPolicy.BackoffStrategy {
    private final Registry registry;
    private final RetryPolicy.BackoffStrategy delegate;

    public InstrumentedBackoffStrategy(Registry registry) {
        this(registry, PredefinedRetryPolicies.DEFAULT_BACKOFF_STRATEGY);
    }

    public InstrumentedBackoffStrategy(Registry registry, RetryPolicy.BackoffStrategy delegate) {
        this.registry = Objects.requireNonNull(registry, "registry");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    public long delayBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
        long delay = this.delegate.delayBeforeNextRetry(originalRequest, exception, retriesAttempted);
        this.registry.distributionSummary("AWS_delay", AwsMetricsSupport.buildExceptionTags(originalRequest, (Exception)exception)).record(delay);
        return delay;
    }
}

