/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.MetricCollector;
import com.amazonaws.retry.RetryPolicy;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.aws.SpectatorMetricCollector;
import com.netflix.spinnaker.kork.aws.InstrumentedBackoffStrategy;
import com.netflix.spinnaker.kork.aws.InstrumentedRetryCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AwsComponents {
    @Bean
    @ConditionalOnMissingBean(value={AWSCredentialsProvider.class})
    AWSCredentialsProvider awsCredentialsProvider() {
        return new DefaultAWSCredentialsProviderChain();
    }

    @Bean
    RetryPolicy.RetryCondition instrumentedRetryCondition(Registry registry) {
        return new InstrumentedRetryCondition(registry);
    }

    @Bean
    RetryPolicy.BackoffStrategy instrumentedBackoffStrategy(Registry registry) {
        return new InstrumentedBackoffStrategy(registry);
    }

    @Bean
    @ConditionalOnProperty(value={"aws.metrics.enabled"}, matchIfMissing=true)
    SpectatorMetricCollector spectatorMetricsCollector(Registry registry) {
        SpectatorMetricCollector collector = new SpectatorMetricCollector(registry);
        AwsSdkMetrics.setMetricCollector((MetricCollector)collector);
        return collector;
    }
}

