/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.configserver.autoconfig;

import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class RemoteConfigSourceConfigured
implements Condition {
    private static final String DEFAULT_REMOTE_REPO_TYPES = "default,git,vault,jdbc,credhub,awsS3";

    public boolean matches(ConditionContext context, @NotNull AnnotatedTypeMetadata metadata) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory != null) {
            Environment environment = context.getEnvironment();
            String remoteRepoTypes = environment.getProperty("spring.cloud.config.remote-repo-types", DEFAULT_REMOTE_REPO_TYPES);
            for (String remoteRepoType : StringUtils.split((String)remoteRepoTypes, (char)',')) {
                if (!beanFactory.containsBean(remoteRepoType + "EnvironmentRepository") && !beanFactory.containsBean(remoteRepoType + "-env-repo0")) continue;
                return true;
            }
        }
        return false;
    }
}

