/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.configserver;

import com.netflix.spinnaker.kork.configserver.ConfigFileLoadingException;
import com.netflix.spinnaker.kork.configserver.ConfigFileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.resource.NoSuchResourceException;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.cloud.config.server.support.EnvironmentPropertySource;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;

public class CloudConfigResourceService
implements EnvironmentAware {
    private static final String CONFIG_SERVER_RESOURCE_PREFIX = "configserver:";
    private final ResourceRepository resourceRepository;
    private final EnvironmentRepository environmentRepository;
    @Value(value="${spring.application.name:application}")
    private String applicationName = "application";
    private String profiles;

    public CloudConfigResourceService() {
        this.resourceRepository = null;
        this.environmentRepository = null;
    }

    public CloudConfigResourceService(ResourceRepository resourceRepository, EnvironmentRepository environmentRepository) {
        this.resourceRepository = resourceRepository;
        this.environmentRepository = environmentRepository;
    }

    public String getLocalPath(String path) {
        String contents = this.retrieveFromConfigServer(path);
        return ConfigFileUtils.writeToTempFile(contents, this.getResourceName(path));
    }

    private String retrieveFromConfigServer(String path) {
        String string;
        block10: {
            if (this.resourceRepository == null || this.environmentRepository == null) {
                throw new ConfigFileLoadingException("Config Server repository not configured for resource \"" + path + "\"");
            }
            String fileName = this.getResourceName(path);
            Resource resource = this.resourceRepository.findOne(this.applicationName, this.profiles, null, fileName);
            InputStream inputStream = resource.getInputStream();
            try {
                Environment environment = this.environmentRepository.findOne(this.applicationName, this.profiles, null);
                String text = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                StandardEnvironment preparedEnvironment = EnvironmentPropertySource.prepareEnvironment((Environment)environment);
                string = EnvironmentPropertySource.resolvePlaceholders((StandardEnvironment)preparedEnvironment, (String)text);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchResourceException e) {
                    throw new ConfigFileLoadingException("The resource \"" + path + "\" was not found in config server", e);
                }
                catch (IOException e) {
                    throw new ConfigFileLoadingException("Exception reading config server resource \"" + path + "\"", e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    private String getResourceName(String path) {
        return path.substring(CONFIG_SERVER_RESOURCE_PREFIX.length());
    }

    public void setEnvironment(org.springframework.core.env.Environment environment) {
        this.profiles = StringUtils.join((Object[])environment.getActiveProfiles(), (String)",");
    }

    public static boolean isCloudConfigResource(String path) {
        return path.startsWith(CONFIG_SERVER_RESOURCE_PREFIX);
    }
}

