/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.configserver.autoconfig;

import com.netflix.spinnaker.kork.configserver.autoconfig.RemoteConfigSourceConfigured;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.cloud.aws.context.config.annotation.ContextResourceLoaderConfiguration;
import org.springframework.cloud.aws.context.support.io.SimpleStorageProtocolResolverConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"awss3"})
@Conditional(value={RemoteConfigSourceConfigured.class})
@AutoConfigureAfter(value={ContextResourceLoaderConfiguration.class})
class SpringCloudAwsS3ResourceLoaderConfiguration {
    SpringCloudAwsS3ResourceLoaderConfiguration() {
    }

    @Bean
    public AwsS3ResourceLoaderBeanPostProcessor awsS3ResourceLoaderBeanPostProcessor() {
        return new AwsS3ResourceLoaderBeanPostProcessor();
    }

    private static class AwsS3ResourceLoaderBeanPostProcessor
    implements BeanFactoryPostProcessor {
        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            String[] beanNames;
            for (String beanName : beanNames = beanFactory.getBeanNamesForType(SimpleStorageProtocolResolverConfigurer.class)) {
                beanFactory.getBean(beanName);
            }
        }
    }
}

