/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.configserver;

import com.netflix.spinnaker.kork.configserver.ConfigFileLoadingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigFileUtils.class);

    static String writeToTempFile(String contents, String resourceName) {
        try {
            Path tempDirPath = Paths.get(System.getProperty("java.io.tmpdir"), resourceName);
            ConfigFileUtils.createParentDirsIfNecessary(tempDirPath);
            Files.write(tempDirPath, contents.getBytes(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            return tempDirPath.toString();
        }
        catch (IOException e) {
            throw new ConfigFileLoadingException("Exception writing local file for resource \"" + resourceName + "\": " + e.getMessage(), e);
        }
    }

    private static void createParentDirsIfNecessary(Path tempDirPath) throws IOException {
        if (Files.notExists(tempDirPath, new LinkOption[0]) && tempDirPath.getParent() != null) {
            Files.createDirectories(tempDirPath.getParent(), new FileAttribute[0]);
        }
    }
}

