/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.configserver;

import com.netflix.spinnaker.kork.configserver.CloudConfigResourceService;
import com.netflix.spinnaker.kork.configserver.ConfigFileLoadingException;
import org.springframework.beans.BeansException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public class CloudConfigAwarePropertySource
extends EnumerablePropertySource<PropertySource> {
    private final ConfigurableApplicationContext context;
    private CloudConfigResourceService resourceService;

    CloudConfigAwarePropertySource(PropertySource source, ConfigurableApplicationContext context) {
        super(source.getName(), (Object)source);
        this.context = context;
    }

    public Object getProperty(String name) {
        String stringValue;
        Object value = ((PropertySource)this.source).getProperty(name);
        if (value instanceof String && CloudConfigResourceService.isCloudConfigResource(stringValue = (String)value)) {
            this.resolveResourceService(stringValue);
            value = this.resourceService.getLocalPath(stringValue);
        }
        return value;
    }

    private void resolveResourceService(String path) {
        if (this.resourceService == null) {
            try {
                this.resourceService = (CloudConfigResourceService)this.context.getBean(CloudConfigResourceService.class);
            }
            catch (BeansException e) {
                throw new ConfigFileLoadingException("Config Server repository not configured for resource \"" + path + "\"");
            }
        }
    }

    public String[] getPropertyNames() {
        if (this.source instanceof EnumerablePropertySource) {
            return ((EnumerablePropertySource)this.source).getPropertyNames();
        }
        return new String[0];
    }
}

